/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.engine.AbstractRedBlackTree;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;

public class LimitedSizeLongTreeChain
extends AbstractRedBlackTree
implements Reopenable {
    private static final long CHAIN_END = -1L;
    private static final long FREE_SLOT = -2L;
    private final TreeCursor cursor = new TreeCursor();
    private final MemoryARW valueChain;
    private final boolean isFirstN;
    private final long maxValues;
    private long currentValues = 0L;
    private long minMaxRowId = -1L;
    private long minMaxNode = -1L;
    private final LongList freeList;
    private final LongList chainFreeList;

    public LimitedSizeLongTreeChain(long keyPageSize, int keyMaxPages, long valuePageSize, int valueMaxPages, boolean isfirstN, long maxValues) {
        super(keyPageSize, keyMaxPages);
        this.valueChain = Vm.getARWInstance(valuePageSize, valueMaxPages, 6);
        this.freeList = new LongList();
        this.chainFreeList = new LongList();
        this.isFirstN = isfirstN;
        this.maxValues = maxValues;
    }

    @Override
    public void clear() {
        super.clear();
        this.valueChain.jumpTo(0L);
        this.minMaxRowId = -1L;
        this.minMaxNode = -1L;
        this.currentValues = 0L;
        this.freeList.clear();
        this.chainFreeList.clear();
        this.cursor.clear();
    }

    @Override
    public void close() {
        this.clear();
        super.close();
        Misc.free(this.valueChain);
    }

    @Override
    public void reopen() {
        super.reopen();
    }

    @Override
    public long size() {
        return this.currentValues;
    }

    private long appendValue(long value, long prevValueOffset) {
        long offset = this.valueChain.getAppendOffset();
        this.valueChain.putLongLong(value, prevValueOffset);
        return offset;
    }

    public TreeCursor getCursor() {
        this.cursor.toTop();
        return this.cursor;
    }

    public long find(Record searchedRecord, RecordCursor sourceCursor, Record placeholder, RecordComparator comparator) {
        comparator.setLeft(searchedRecord);
        if (this.root == -1L) {
            return -1L;
        }
        long p = this.root;
        do {
            sourceCursor.recordAt(placeholder, this.valueChain.getLong(LimitedSizeLongTreeChain.refOf(p)));
            int cmp = comparator.compare(placeholder);
            if (cmp < 0) {
                p = LimitedSizeLongTreeChain.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = LimitedSizeLongTreeChain.rightOf(p);
                continue;
            }
            return p;
        } while (p > -1L);
        return -1L;
    }

    public void put(Record leftRecord, RecordCursor sourceCursor, Record rightRecord, RecordComparator comparator) {
        int cmp;
        long parent;
        if (this.maxValues == 0L) {
            return;
        }
        comparator.setLeft(leftRecord);
        if (this.maxValues == this.currentValues) {
            sourceCursor.recordAt(rightRecord, this.minMaxRowId);
            int cmp2 = comparator.compare(rightRecord);
            if (this.isFirstN && cmp2 >= 0) {
                return;
            }
            if (!this.isFirstN && cmp2 <= 0) {
                return;
            }
            this.removeAndCache(this.minMaxNode);
        }
        if (this.root == -1L) {
            this.putParent(leftRecord.getRowId());
            this.minMaxNode = this.root;
            this.minMaxRowId = leftRecord.getRowId();
            ++this.currentValues;
            return;
        }
        long p = this.root;
        do {
            parent = p;
            long r = LimitedSizeLongTreeChain.refOf(p);
            sourceCursor.recordAt(rightRecord, this.valueChain.getLong(r));
            cmp = comparator.compare(rightRecord);
            if (cmp < 0) {
                p = LimitedSizeLongTreeChain.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = LimitedSizeLongTreeChain.rightOf(p);
                continue;
            }
            LimitedSizeLongTreeChain.setRef(p, this.appendValue(leftRecord.getRowId(), r));
            if (this.minMaxRowId == -1L) {
                this.refreshMinMaxNode();
            }
            ++this.currentValues;
            return;
        } while (p > -1L);
        p = this.allocateBlock(parent, leftRecord.getRowId());
        if (cmp < 0) {
            LimitedSizeLongTreeChain.setLeft(parent, p);
        } else {
            LimitedSizeLongTreeChain.setRight(parent, p);
        }
        this.fixInsert(p);
        this.refreshMinMaxNode();
        ++this.currentValues;
    }

    protected long allocateBlock(long parent, long recordRowId) {
        long chainOffset;
        if (this.freeList.size() > 0) {
            long freeNode = this.freeList.get(this.freeList.size() - 1);
            this.freeList.removeIndex(this.freeList.size() - 1);
            LimitedSizeLongTreeChain.setParent(freeNode, parent);
            this.valueChain.putLong(LimitedSizeLongTreeChain.refOf(freeNode), recordRowId);
            return freeNode;
        }
        long newNode = super.allocateBlock();
        LimitedSizeLongTreeChain.setParent(newNode, parent);
        if (this.chainFreeList.size() > 0) {
            chainOffset = this.chainFreeList.get(this.chainFreeList.size() - 1);
            this.chainFreeList.removeIndex(this.chainFreeList.size() - 1);
            this.valueChain.putLong(chainOffset, recordRowId);
            this.valueChain.putLong(chainOffset + 8L, -1L);
        } else {
            chainOffset = this.appendValue(recordRowId, -1L);
        }
        LimitedSizeLongTreeChain.setRef(newNode, chainOffset);
        return newNode;
    }

    private void refreshMinMaxNode() {
        long p = this.isFirstN ? this.findMaxNode() : this.findMinNode();
        this.minMaxNode = p;
        this.minMaxRowId = this.valueChain.getLong(LimitedSizeLongTreeChain.refOf(p));
    }

    protected void removeAndCache(long node) {
        if (this.hasMoreThanOneValue(node)) {
            this.removeMostRecentChainValue(node);
        } else {
            long nodeToRemove = super.remove(node);
            this.clearBlock(nodeToRemove);
            this.freeList.add(nodeToRemove);
            this.minMaxRowId = -1L;
            this.minMaxNode = -1L;
        }
        --this.currentValues;
    }

    private void clearBlock(long position) {
        LimitedSizeLongTreeChain.setParent(position, -1L);
        LimitedSizeLongTreeChain.setLeft(position, -1L);
        LimitedSizeLongTreeChain.setRight(position, -1L);
        LimitedSizeLongTreeChain.setColor(position, (byte)0);
        long refOffset = LimitedSizeLongTreeChain.refOf(position);
        assert (this.valueChain.getLong(refOffset + 8L) == -1L);
        this.valueChain.putLong(refOffset, -2L);
    }

    private void removeMostRecentChainValue(long node) {
        long ref = LimitedSizeLongTreeChain.refOf(node);
        long previousOffset = this.valueChain.getLong(ref + 8L);
        LimitedSizeLongTreeChain.setRef(node, previousOffset);
        this.valueChain.putLong(ref, -1L);
        this.valueChain.putLong(ref + 8L, -1L);
        this.chainFreeList.add(ref);
    }

    private boolean hasMoreThanOneValue(long position) {
        long ref = LimitedSizeLongTreeChain.refOf(position);
        long previousOffset = this.valueChain.getLong(ref + 8L);
        return previousOffset != -1L;
    }

    @Override
    protected void putParent(long value) {
        this.root = this.allocateBlock(-1L, value);
    }

    public void print(CharSink sink) {
        this.print(sink, null);
    }

    public void print(CharSink sink, ValuePrinter printer) {
        if (this.root == -1L) {
            sink.put("[EMPTY TREE]");
        } else {
            if (printer == null) {
                printer = ValuePrinter::toRowId;
            }
            this.printTree(sink, this.root, 0, false, printer);
        }
    }

    void printTree(CharSink sink, long node, int level, boolean isLeft, ValuePrinter printer) {
        byte color = LimitedSizeLongTreeChain.colorOf(node);
        long valueOffset = LimitedSizeLongTreeChain.refOf(node);
        long value = this.valueChain.getLong(valueOffset);
        for (int i = 1; i < level; ++i) {
            sink.put(' ').put(' ');
        }
        if (level > 0) {
            sink.put(' ');
            sink.put(isLeft ? (char)'L' : 'R');
            sink.put('-');
        }
        sink.put('[');
        sink.put(color == 1 ? "Red" : (color == 0 ? "Black" : "Unkown_Color"));
        sink.put(',');
        sink.put(printer.toString(value));
        int chainLength = this.getChainLength(valueOffset);
        if (chainLength > 1) {
            sink.put('(').put(chainLength).put(')');
        }
        sink.put(']');
        sink.put('\n');
        if (LimitedSizeLongTreeChain.leftOf(node) != -1L) {
            this.printTree(sink, LimitedSizeLongTreeChain.leftOf(node), level + 1, true, printer);
        }
        if (LimitedSizeLongTreeChain.rightOf(node) != -1L) {
            this.printTree(sink, LimitedSizeLongTreeChain.rightOf(node), level + 1, false, printer);
        }
    }

    private int getChainLength(long chainStart) {
        int counter = 1;
        long nextOffset = this.valueChain.getLong(chainStart + 8L);
        while (nextOffset != -1L) {
            nextOffset = this.valueChain.getLong(nextOffset + 8L);
            ++counter;
        }
        return counter;
    }

    @FunctionalInterface
    public static interface ValuePrinter {
        public String toString(long var1);

        public static String toRowId(long rowid) {
            return String.valueOf(rowid);
        }
    }

    public class TreeCursor {
        private long treeCurrent;
        private long chainCurrent;

        public boolean hasNext() {
            if (this.chainCurrent != -1L) {
                return true;
            }
            this.treeCurrent = LimitedSizeLongTreeChain.successor(this.treeCurrent);
            if (this.treeCurrent == -1L) {
                return false;
            }
            this.chainCurrent = LimitedSizeLongTreeChain.refOf(this.treeCurrent);
            return true;
        }

        public long next() {
            long result = this.chainCurrent;
            this.chainCurrent = LimitedSizeLongTreeChain.this.valueChain.getLong(this.chainCurrent + 8L);
            return LimitedSizeLongTreeChain.this.valueChain.getLong(result);
        }

        public void toTop() {
            this.setup();
        }

        private void setup() {
            long p = LimitedSizeLongTreeChain.this.root;
            if (p != -1L) {
                while (LimitedSizeLongTreeChain.leftOf(p) != -1L) {
                    p = LimitedSizeLongTreeChain.leftOf(p);
                }
            }
            this.treeCurrent = p;
            this.chainCurrent = LimitedSizeLongTreeChain.refOf(this.treeCurrent);
        }

        public void clear() {
            this.treeCurrent = 0L;
            this.chainCurrent = 0L;
        }
    }
}

