/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.WriterOutOfDateException;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class InsertOperationImpl
implements InsertOperation {
    private final long structureVersion;
    private final String tableName;
    private final InsertMethodImpl insertMethod = new InsertMethodImpl();
    private final ObjList<InsertRowImpl> insertRows = new ObjList();
    private final CairoEngine engine;
    private final InsertOperationFuture doneFuture = new InsertOperationFuture();

    public InsertOperationImpl(CairoEngine engine, String tableName, long structureVersion) {
        this.engine = engine;
        this.tableName = tableName;
        this.structureVersion = structureVersion;
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext) throws SqlException {
        return this.createMethod(executionContext, this.engine);
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext, WriterSource writerSource) throws SqlException {
        this.initContext(executionContext);
        if (this.insertMethod.writer == null) {
            TableWriter writer = writerSource.getWriter(executionContext.getCairoSecurityContext(), this.tableName, "insert");
            if (writer.getStructureVersion() != this.structureVersion) {
                writer.close();
                throw WriterOutOfDateException.INSTANCE;
            }
            this.insertMethod.writer = writer;
        }
        return this.insertMethod;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void addInsertRow(InsertRowImpl row) {
        this.insertRows.add(row);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext) throws SqlException {
        try (InsertMethod insertMethod = this.createMethod(sqlExecutionContext);){
            insertMethod.execute();
            insertMethod.commit();
            InsertOperationFuture insertOperationFuture = this.doneFuture;
            return insertOperationFuture;
        }
    }

    private void initContext(SqlExecutionContext executionContext) throws SqlException {
        int n = this.insertRows.size();
        for (int i = 0; i < n; ++i) {
            InsertRowImpl row = this.insertRows.get(i);
            row.initContext(executionContext);
        }
    }

    private class InsertOperationFuture
    extends DoneOperationFuture {
        private InsertOperationFuture() {
        }

        @Override
        public long getInstanceId() {
            return -3L;
        }

        @Override
        public long getAffectedRowsCount() {
            return InsertOperationImpl.this.insertRows.size();
        }
    }

    private class InsertMethodImpl
    implements InsertMethod {
        private TableWriter writer = null;

        private InsertMethodImpl() {
        }

        @Override
        public long execute() throws SqlException {
            int n = InsertOperationImpl.this.insertRows.size();
            for (int i = 0; i < n; ++i) {
                InsertRowImpl row = (InsertRowImpl)InsertOperationImpl.this.insertRows.get(i);
                row.append(this.writer);
            }
            return InsertOperationImpl.this.insertRows.size();
        }

        @Override
        public void commit() {
            this.writer.commit();
        }

        @Override
        public TableWriter popWriter() {
            TableWriter w = this.writer;
            this.writer = null;
            return w;
        }

        @Override
        public void close() {
            this.writer = Misc.free(this.writer);
        }
    }
}

