/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class AlterOperationBuilder {
    private final ObjList<CharSequence> objCharList = new ObjList();
    private final LongList longList = new LongList();
    private final AlterOperation resultInstance = new AlterOperation(this.longList, this.objCharList);
    private short command;
    private String tableName;
    private int tableId = -1;
    private int tableNamePosition = -1;

    public void clear() {
        this.resultInstance.clear();
        this.objCharList.clear();
        this.longList.clear();
        this.command = 0;
        this.tableName = null;
        this.tableId = -1;
        this.tableNamePosition = -1;
    }

    public AlterOperation build() {
        return this.resultInstance.of(this.command, this.tableName, this.tableId, this.tableNamePosition);
    }

    public AlterOperationBuilder ofAddColumn(int tableNamePosition, String tableName, int tableId) {
        this.command = 1;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofAddIndex(int tableNamePosition, String tableName, int tableId, CharSequence columnName, int indexValueBlockSize) {
        this.command = (short)4;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        this.objCharList.add(columnName);
        this.longList.add(indexValueBlockSize);
        return this;
    }

    public AlterOperationBuilder ofDropIndex(int tableNamePosition, String tableName, int tableId, CharSequence columnName) {
        this.command = (short)5;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        this.objCharList.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofAttachPartition(int tableNamePosition, String tableName, int tableId) {
        this.command = (short)3;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDetachPartition(int tableNamePosition, String tableName, int tableId) {
        this.command = (short)12;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofCacheSymbol(int tableNamePosition, String tableName, int tableId, CharSequence columnName) {
        this.command = (short)6;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        this.objCharList.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofRemoveCacheSymbol(int tableNamePosition, String tableName, int tableId, CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.command = (short)7;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        this.objCharList.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofDropColumn(CharSequence columnName) {
        assert (columnName != null && columnName.length() > 0);
        this.objCharList.add(columnName);
        return this;
    }

    public AlterOperationBuilder ofDropColumn(int tableNamePosition, String tableName, int tableId) {
        this.command = (short)8;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofDropPartition(int tableNamePosition, String tableName, int tableId) {
        this.command = (short)2;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofRenameColumn(int tableNamePosition, String tableName, int tableId) {
        this.command = (short)9;
        this.tableNamePosition = tableNamePosition;
        this.tableName = tableName;
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetParamCommitLag(String tableName, int tableId, long commitLag) {
        this.command = (short)11;
        this.tableName = tableName;
        this.longList.add(commitLag);
        this.tableId = tableId;
        return this;
    }

    public AlterOperationBuilder ofSetParamUncommittedRows(String tableName, int tableId, int maxUncommittedRows) {
        this.command = (short)10;
        this.tableName = tableName;
        this.longList.add(maxUncommittedRows);
        this.tableId = tableId;
        return this;
    }

    public void ofRenameColumn(CharSequence columnName, CharSequence newName) {
        this.objCharList.add(columnName);
        this.objCharList.add(newName);
    }

    public void ofPartition(long timestamp) {
        this.longList.add(timestamp);
    }

    public void ofAddColumn(CharSequence columnName, int type, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity) {
        assert (columnName != null && columnName.length() > 0);
        this.objCharList.add(columnName);
        this.longList.add(type);
        this.longList.add(symbolCapacity);
        this.longList.add(cache ? 1L : -1L);
        this.longList.add(indexed ? 1L : -1L);
        this.longList.add(indexValueBlockCapacity);
    }
}

