/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.AttachDetachStatus;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectCharSequence;
import io.questdb.tasks.TableWriterTask;

public class AlterOperation
extends AbstractOperation
implements Mutable {
    public static final String CMD_NAME = "ALTER TABLE";
    public static final short DO_NOTHING = 0;
    public static final short ADD_COLUMN = 1;
    public static final short DROP_PARTITION = 2;
    public static final short ATTACH_PARTITION = 3;
    public static final short ADD_INDEX = 4;
    public static final short DROP_INDEX = 5;
    public static final short ADD_SYMBOL_CACHE = 6;
    public static final short REMOVE_SYMBOL_CACHE = 7;
    public static final short DROP_COLUMN = 8;
    public static final short RENAME_COLUMN = 9;
    public static final short SET_PARAM_MAX_UNCOMMITTED_ROWS = 10;
    public static final short SET_PARAM_COMMIT_LAG = 11;
    public static final short DETACH_PARTITION = 12;
    private static final Log LOG = LogFactory.getLog(AlterOperation.class);
    private final ObjCharSequenceList objCharList;
    private final DirectCharSequenceList directCharList = new DirectCharSequenceList();
    private final LongList longList;
    private final ExceptionSinkAdapter exceptionSinkAdapter = new ExceptionSinkAdapter();
    private short command;
    private CharSequenceList charSequenceList;

    public AlterOperation() {
        this(new LongList(), new ObjList<CharSequence>());
    }

    public AlterOperation(LongList longList, ObjList<CharSequence> charSequenceObjList) {
        this.longList = longList;
        this.objCharList = new ObjCharSequenceList(charSequenceObjList);
        this.command = 0;
    }

    @Override
    public long apply(TableWriter tableWriter, boolean contextAllowsAnyStructureChanges) throws SqlException, AlterTableContextException {
        try {
            switch (this.command) {
                case 1: {
                    this.applyAddColumn(tableWriter);
                    break;
                }
                case 8: {
                    if (!contextAllowsAnyStructureChanges) {
                        throw AlterTableContextException.INSTANCE;
                    }
                    this.applyDropColumn(tableWriter);
                    break;
                }
                case 9: {
                    if (!contextAllowsAnyStructureChanges) {
                        throw AlterTableContextException.INSTANCE;
                    }
                    this.applyRenameColumn(tableWriter);
                    break;
                }
                case 2: {
                    this.applyDropPartition(tableWriter);
                    break;
                }
                case 12: {
                    this.applyDetachPartition(tableWriter);
                    break;
                }
                case 3: {
                    this.applyAttachPartition(tableWriter);
                    break;
                }
                case 4: {
                    this.applyAddIndex(tableWriter);
                    break;
                }
                case 5: {
                    this.applyDropIndex(tableWriter);
                    break;
                }
                case 6: {
                    this.applySetSymbolCache(tableWriter, true);
                    break;
                }
                case 7: {
                    this.applySetSymbolCache(tableWriter, false);
                    break;
                }
                case 10: {
                    this.applyParamUncommittedRows(tableWriter);
                    break;
                }
                case 11: {
                    this.applyParamCommitLag(tableWriter);
                    break;
                }
                default: {
                    LOG.error().$("Invalid alter table command [code=").$(this.command).$(" ,table=").$(this.tableName).I$();
                    throw SqlException.$(this.tableNamePosition, "Invalid alter table command [code=").put(this.command).put(']');
                }
            }
        }
        catch (EntryUnavailableException | SqlException ex) {
            throw ex;
        }
        catch (CairoException e2) {
            LOG.error().$("table '").$(this.tableName).$("' could not be altered [").$(e2.getErrno()).$("] ").$(e2.getFlyweightMessage()).$();
            throw SqlException.$(this.tableNamePosition, "table '").put(this.tableName).put("' could not be altered: [").put(e2.getErrno()).put("] ").put(e2.getFlyweightMessage());
        }
        return 0L;
    }

    @Override
    public AlterOperation deserialize(TableWriterTask event) {
        this.clear();
        this.tableName = event.getTableName();
        long readPtr = event.getData();
        long hi = readPtr + event.getDataSize();
        if (readPtr + 10L >= hi) {
            throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [1]");
        }
        this.command = Unsafe.getUnsafe().getShort(readPtr);
        this.tableNamePosition = Unsafe.getUnsafe().getInt(readPtr += 2L);
        int longSize = Unsafe.getUnsafe().getInt(readPtr += 4L);
        if (longSize < 0 || (readPtr += 4L) + (long)longSize * 8L >= hi) {
            throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [2]");
        }
        for (int i = 0; i < longSize; ++i) {
            this.longList.add(Unsafe.getUnsafe().getLong(readPtr));
            readPtr += 8L;
        }
        this.directCharList.of(readPtr, hi);
        this.charSequenceList = this.directCharList;
        return this;
    }

    @Override
    public void startAsync() {
    }

    @Override
    public void clear() {
        this.command = 0;
        this.objCharList.clear();
        this.directCharList.clear();
        this.charSequenceList = this.objCharList;
        this.longList.clear();
        this.clearCommandCorrelationId();
    }

    public AlterOperation of(short command, String tableName, int tableId, int tableNamePosition) {
        this.init(2, CMD_NAME, tableName, tableId, -1L, tableNamePosition);
        this.command = command;
        return this;
    }

    @Override
    public void serialize(TableWriterTask event) {
        int i;
        super.serialize(event);
        event.putShort(this.command);
        event.putInt(this.tableNamePosition);
        event.putInt(this.longList.size());
        int n = this.longList.size();
        for (i = 0; i < n; ++i) {
            event.putLong(this.longList.getQuick(i));
        }
        event.putInt(this.objCharList.size());
        n = this.objCharList.size();
        for (i = 0; i < n; ++i) {
            event.putStr(this.objCharList.getStrA(i));
        }
    }

    private void applyAddColumn(TableWriter tableWriter) throws SqlException {
        int lParam = 0;
        int n = this.charSequenceList.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = this.charSequenceList.getStrA(i);
            int type = (int)this.longList.get(lParam++);
            int symbolCapacity = (int)this.longList.get(lParam++);
            boolean symbolCacheFlag = this.longList.get(lParam++) > 0L;
            boolean isIndexed = this.longList.get(lParam++) > 0L;
            int indexValueBlockCapacity = (int)this.longList.get(lParam++);
            try {
                tableWriter.addColumn(columnName, type, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, false);
                continue;
            }
            catch (CairoException e) {
                LOG.error().$("Cannot add column '").$(tableWriter.getTableName()).$('.').$(columnName).$("'. Exception: ").$(e).$();
                throw SqlException.$(this.tableNamePosition, "could not add column [error=").put(e.getFlyweightMessage()).put(", errno=").put(e.getErrno()).put(']');
            }
        }
    }

    private void applyAddIndex(TableWriter tableWriter) throws SqlException {
        CharSequence columnName = this.charSequenceList.getStrA(0);
        try {
            int indexValueBlockSize = (int)this.longList.get(0);
            tableWriter.addIndex(columnName, indexValueBlockSize);
        }
        catch (CairoException e) {
            throw SqlException.position(this.tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void applyDropIndex(TableWriter tableWriter) throws SqlException {
        CharSequence columnName = this.charSequenceList.getStrA(0);
        try {
            tableWriter.dropIndex(columnName);
        }
        catch (CairoException e) {
            throw SqlException.position(this.tableNamePosition).put(e.getFlyweightMessage()).put("[errno=").put(e.getErrno()).put(']');
        }
    }

    private void applyAttachPartition(TableWriter tableWriter) throws SqlException {
        int n = this.longList.size();
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.longList.getQuick(i);
            try {
                AttachDetachStatus attachDetachStatus = tableWriter.attachPartition(partitionTimestamp);
                if (attachDetachStatus == AttachDetachStatus.OK) continue;
                throw this.putPartitionName(SqlException.$(this.tableNamePosition, "failed to attach partition '"), tableWriter.getPartitionBy(), partitionTimestamp).put("': ").put(attachDetachStatus.name());
            }
            catch (CairoException e) {
                LOG.error().$("failed to attach partition [table=").$(this.tableName).$(", ts=").$ts(partitionTimestamp).$(", errno=").$(e.getErrno()).$(", error=").$(e.getFlyweightMessage()).I$();
                throw e;
            }
        }
    }

    private void applyDetachPartition(TableWriter tableWriter) throws SqlException {
        int n = this.longList.size();
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.longList.getQuick(i);
            try {
                AttachDetachStatus attachDetachStatus = tableWriter.detachPartition(partitionTimestamp);
                if (AttachDetachStatus.OK == attachDetachStatus) continue;
                throw this.putPartitionName(SqlException.$(this.tableNamePosition, "could not detach [statusCode=").put(attachDetachStatus.name()).put(", table=").put(this.tableName).put(", partition='"), tableWriter.getPartitionBy(), partitionTimestamp).put("']");
            }
            catch (CairoException e) {
                LOG.error().$("failed to detach partition [table=").$(this.tableName).$(", ts=").$ts(partitionTimestamp).$(", errno=").$(e.getErrno()).$(", error=").$(e.getFlyweightMessage()).I$();
                throw e;
            }
        }
    }

    private void applyDropColumn(TableWriter writer) throws SqlException {
        int n = this.charSequenceList.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = this.charSequenceList.getStrA(i);
            TableWriterMetadata metadata = writer.getMetadata();
            if (metadata.getColumnIndexQuiet(columnName) == -1) {
                throw SqlException.invalidColumn(this.tableNamePosition, columnName);
            }
            try {
                writer.removeColumn(columnName);
                continue;
            }
            catch (CairoException e) {
                LOG.error().$("cannot drop column '").$(writer.getTableName()).$('.').$(columnName).$("'. Exception: ").$(e).$();
                throw SqlException.$(this.tableNamePosition, "cannot drop column. Try again later [errno=").put(e.getErrno()).put(']');
            }
        }
    }

    private void applyDropPartition(TableWriter tableWriter) throws SqlException {
        int n = this.longList.size();
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.longList.getQuick(i);
            try {
                if (tableWriter.removePartition(partitionTimestamp)) continue;
                throw this.putPartitionName(SqlException.$(this.tableNamePosition, "could not remove partition '"), tableWriter.getPartitionBy(), partitionTimestamp).put('\'');
            }
            catch (CairoException e) {
                LOG.error().$("failed to drop partition [table=").$(this.tableName).$(",ts=").$ts(partitionTimestamp).$(",errno=").$(e.getErrno()).$(",error=").$(e.getFlyweightMessage()).I$();
                throw this.putPartitionName(SqlException.$(this.tableNamePosition, "could not remove partition '"), tableWriter.getPartitionBy(), partitionTimestamp).put("'. ").put(e.getFlyweightMessage());
            }
        }
    }

    private void applyParamCommitLag(TableWriter tableWriter) {
        long commitLag = this.longList.get(0);
        tableWriter.setMetaCommitLag(commitLag);
    }

    private void applyParamUncommittedRows(TableWriter tableWriter) {
        int maxUncommittedRows = (int)this.longList.get(0);
        tableWriter.setMetaMaxUncommittedRows(maxUncommittedRows);
    }

    private void applyRenameColumn(TableWriter writer) throws SqlException {
        int i = 0;
        int n = this.charSequenceList.size();
        while (i < n) {
            CharSequence columnName = this.charSequenceList.getStrA(i++);
            CharSequence newName = this.charSequenceList.getStrB(i++);
            try {
                writer.renameColumn(columnName, newName);
            }
            catch (CairoException e) {
                LOG.error().$("cannot rename column '").$(writer.getTableName()).$('.').$(columnName).$("'. Exception: ").$(e).$();
                throw SqlException.$(this.tableNamePosition, "cannot rename column \"").put(columnName).put("\"; ").put(e.getFlyweightMessage());
            }
        }
    }

    private void applySetSymbolCache(TableWriter tableWriter, boolean isCacheOn) throws SqlException {
        CharSequence columnName = this.charSequenceList.getStrA(0);
        int columnIndex = tableWriter.getMetadata().getColumnIndexQuiet(columnName);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(this.tableNamePosition, columnName);
        }
        tableWriter.changeCacheFlag(columnIndex, isCacheOn);
    }

    private SqlException putPartitionName(SqlException ex, int partitionBy, long timestamp) {
        PartitionBy.setSinkForPartition(this.exceptionSinkAdapter.of(ex), partitionBy, timestamp, false);
        return ex;
    }

    private static class DirectCharSequenceList
    implements CharSequenceList {
        private final LongList offsets = new LongList();
        private final DirectCharSequence strA = new DirectCharSequence();
        private final DirectCharSequence strB = new DirectCharSequence();

        private DirectCharSequenceList() {
        }

        @Override
        public void clear() {
            this.offsets.clear();
        }

        @Override
        public CharSequence getStrA(int i) {
            long lo = this.offsets.get(i * 2);
            long hi = this.offsets.get(i * 2 + 1);
            this.strA.of(lo, hi);
            return this.strA;
        }

        @Override
        public CharSequence getStrB(int i) {
            long lo = this.offsets.get(i * 2);
            long hi = this.offsets.get(i * 2 + 1);
            this.strB.of(lo, hi);
            return this.strB;
        }

        @Override
        public int size() {
            return this.offsets.size() / 2;
        }

        public long of(long lo, long hi) {
            long initialAddress = lo;
            if (lo + 4L >= hi) {
                throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [11]");
            }
            int size = Unsafe.getUnsafe().getInt(lo);
            lo += 4L;
            for (int i = 0; i < size; ++i) {
                int stringSize;
                if (lo + 4L >= hi) {
                    throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [12]");
                }
                if ((lo += 4L) + (long)(stringSize = 2 * Unsafe.getUnsafe().getInt(lo)) >= hi) {
                    throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [13]");
                }
                this.offsets.add(lo, lo + (long)stringSize);
                lo += (long)stringSize;
            }
            return lo - initialAddress;
        }
    }

    private static class ObjCharSequenceList
    implements CharSequenceList {
        private final ObjList<CharSequence> strings;

        public ObjCharSequenceList(ObjList<CharSequence> strings) {
            this.strings = strings;
        }

        @Override
        public void clear() {
            this.strings.clear();
        }

        @Override
        public CharSequence getStrA(int i) {
            return this.strings.get(i);
        }

        @Override
        public CharSequence getStrB(int i) {
            return this.strings.get(i);
        }

        @Override
        public int size() {
            return this.strings.size();
        }
    }

    private static class ExceptionSinkAdapter
    implements CharSink {
        private SqlException ex;

        private ExceptionSinkAdapter() {
        }

        @Override
        public int encodeSurrogate(char c, CharSequence in, int pos, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] getDoubleDigitsBuffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSink put(CharSequence cs) {
            this.ex.put(cs);
            return this;
        }

        @Override
        public CharSink put(char c) {
            this.ex.put(c);
            return this;
        }

        @Override
        public CharSink put(int c) {
            this.ex.put(c);
            return this;
        }

        @Override
        public CharSink put(long c) {
            this.ex.put(c);
            return this;
        }

        ExceptionSinkAdapter of(SqlException ex) {
            this.ex = ex;
            return this;
        }
    }

    static interface CharSequenceList
    extends Mutable {
        public CharSequence getStrA(int var1);

        public CharSequence getStrB(int var1);

        public int size();
    }
}

