/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class HashOuterJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final HashOuterJoinLightRecordCursor cursor;

    public HashOuterJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashOuterJoinLightRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), joinColumnTypes, valueTypes, configuration);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    private class HashOuterJoinLightRecordCursor
    extends AbstractJoinCursor {
        private final OuterJoinRecord record;
        private final LongChain slaveChain;
        private final Map joinKeyMap;
        private Record masterRecord;
        private LongChain.TreeCursor slaveChainCursor;
        private Record slaveRecord;
        private boolean isOpen;

        public HashOuterJoinLightRecordCursor(int columnSplit, Record nullRecord, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, CairoConfiguration configuration) {
            super(columnSplit);
            this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
            this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.isOpen = true;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChainCursor = this.slaveChain.getCursor(value.getLong(0));
                    this.slaveChainCursor.hasNext();
                    this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                    this.record.hasSlave(true);
                } else {
                    this.slaveChainCursor = null;
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.slaveChain.reopen();
                this.joinKeyMap.reopen();
            }
            this.buildMapOfSlaveRecords(slaveCursor, circuitBreaker);
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
        }

        private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            try {
                Record record = slaveCursor.getRecord();
                while (slaveCursor.hasNext()) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    MapKey key = this.joinKeyMap.withKey();
                    key.put(record, HashOuterJoinLightRecordCursorFactory.this.slaveKeySink);
                    MapValue value = key.createValue();
                    if (value.isNew()) {
                        long offset = this.slaveChain.put(record.getRowId(), -1L);
                        value.putLong(0, offset);
                        value.putLong(1, offset);
                        continue;
                    }
                    value.putLong(1, this.slaveChain.put(record.getRowId(), value.getLong(1)));
                }
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }
    }
}

