/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.std.Misc;

public class HashJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final HashJoinRecordCursor cursor;

    public HashJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashJoinRecordCursor(columnSplit, configuration, joinColumnTypes, valueTypes);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean supportsUpdateRowId(CharSequence tableName) {
        return this.masterFactory.supportsUpdateRowId(tableName);
    }

    private class HashJoinRecordCursor
    extends AbstractJoinCursor {
        private final JoinRecord record;
        private final LongChain slaveChain;
        private final Map joinKeyMap;
        private Record masterRecord;
        private LongChain.TreeCursor slaveChainCursor;
        private Record slaveRecord;
        private boolean isOpen;

        public HashJoinRecordCursor(int columnSplit, CairoConfiguration configuration, ColumnTypes joinColumnTypes, ColumnTypes valueTypes) {
            super(columnSplit);
            this.record = new JoinRecord(columnSplit);
            this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
            this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
            this.isOpen = true;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChainCursor = this.slaveChain.getCursor(value.getLong(0));
                this.slaveChainCursor.hasNext();
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            return false;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            try {
                if (!this.isOpen) {
                    this.isOpen = true;
                    this.joinKeyMap.reopen();
                    this.slaveChain.reopen();
                }
                this.buildMapOfSlaveRecords(slaveCursor, circuitBreaker);
                this.masterCursor = masterCursor;
                this.slaveCursor = slaveCursor;
                this.masterRecord = masterCursor.getRecord();
                this.slaveRecord = slaveCursor.getRecordB();
                this.record.of(this.masterRecord, this.slaveRecord);
                this.slaveChainCursor = null;
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }

        private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            Record record = slaveCursor.getRecord();
            while (slaveCursor.hasNext()) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.joinKeyMap.withKey();
                key.put(record, HashJoinLightRecordCursorFactory.this.slaveKeySink);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    long offset = this.slaveChain.put(record.getRowId(), -1L);
                    value.putLong(0, offset);
                    value.putLong(1, offset);
                    continue;
                }
                value.putLong(1, this.slaveChain.put(record.getRowId(), value.getLong(1)));
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }
    }
}

