/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.CharSink;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class SumDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    private static final int SUM_PADDING = 8;
    private static final int COUNT_PADDING = 8;
    private final int columnIndex;
    private final double[] sum;
    private final long[] count;
    private final int workerCount;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public SumDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        this.sum = new double[workerCount * 8];
        this.count = new long[workerCount * 8];
        this.workerCount = workerCount;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourSumDouble;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntSumDouble;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int columnSizeHint, int workerId) {
        double value;
        if (address != 0L && (value = Vect.sumDouble(address, addressSize / 8L)) == value) {
            int n = workerId * 8;
            this.sum[n] = this.sum[n] + value;
            int n2 = workerId * 8;
            this.count[n2] = this.count[n2] + 1L;
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int columnSizeShr, int workerId) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0.0);
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0.0);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntSumDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(10);
        types.add(6);
    }

    @Override
    public void wrapUp(long pRosti) {
        double sum = 0.0;
        long count = 0L;
        for (int i = 0; i < this.workerCount; ++i) {
            sum += this.sum[i * 8];
            count += this.count[i * 8];
        }
        Rosti.keyedIntSumDoubleWrapUp(pRosti, this.valueOffset, sum, count);
    }

    @Override
    public void clear() {
        Arrays.fill(this.sum, 0.0);
        Arrays.fill(this.count, 0L);
    }

    @Override
    public double getDouble(@Nullable Record rec) {
        double sum = 0.0;
        long count = 0L;
        for (int i = 0; i < this.workerCount; ++i) {
            sum += this.sum[i * 8];
            count += this.count[i * 8];
        }
        return count > 0L ? sum : Double.NaN;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("SumDoubleVector(").put(this.columnIndex).put(')');
    }
}

