/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

public class CountVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    private final LongAdder count = new LongAdder();
    private final CountFunc countFunc;
    private int valueOffset;

    public CountVectorAggregateFunction(int keyKind) {
        this.countFunc = keyKind == 1 ? Rosti::keyedHourCount : Rosti::keyedIntCount;
    }

    @Override
    public void aggregate(long address, long addressSize, int columnSizeHint, int workerId) {
        this.count.add(addressSize >>> columnSizeHint);
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int columnSizeShr, int workerId) {
        return this.countFunc.count(pRosti, keyAddress, valueAddressSize >>> columnSizeShr, this.valueOffset);
    }

    @Override
    public int getColumnIndex() {
        return -1;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntCountMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(6);
    }

    @Override
    public void wrapUp(long pRosti) {
    }

    @Override
    public void clear() {
        this.count.reset();
    }

    @Override
    public long getLong(Record rec) {
        return this.count.sum();
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("CountVectorAgg(").put(this.valueOffset).put(')');
    }

    @FunctionalInterface
    private static interface CountFunc {
        public boolean count(long var1, long var3, long var5, int var7);
    }
}

