/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.datetime.microtime.Timestamps;

class YearTimestampSampler
implements TimestampSampler {
    private final int bucket;
    private int startMonth;
    private int startDay;
    private int startHour;
    private int startMin;
    private int startSec;
    private int startMillis;
    private int startMicros;

    public YearTimestampSampler(int bucket) {
        this.bucket = bucket;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return this.addYears(timestamp, this.bucket);
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return this.addYears(timestamp, -this.bucket);
    }

    @Override
    public long round(long value) {
        int y = Timestamps.getYear(value);
        return Timestamps.toMicros(y - y % this.bucket, Timestamps.isLeapYear(y), this.startDay, this.startMonth, this.startHour, this.startMin, this.startSec, this.startMillis, this.startMicros);
    }

    @Override
    public void setStart(long timestamp) {
        int y = Timestamps.getYear(timestamp);
        boolean leap = Timestamps.isLeapYear(y);
        this.startMonth = Timestamps.getMonthOfYear(timestamp, y, leap);
        this.startDay = Timestamps.getDayOfMonth(timestamp, y, this.startMonth, leap);
        this.startHour = Timestamps.getHourOfDay(timestamp);
        this.startMin = Timestamps.getMinuteOfHour(timestamp);
        this.startSec = Timestamps.getSecondOfMinute(timestamp);
        this.startMillis = Timestamps.getMillisOfSecond(timestamp);
        this.startMicros = Timestamps.getMicrosOfSecond(timestamp);
    }

    private long addYears(long timestamp, int bucket) {
        if (bucket == 0) {
            return timestamp;
        }
        int y = Timestamps.getYear(timestamp);
        boolean leap = Timestamps.isLeapYear(y + bucket);
        int maxDay = Math.min(this.startDay, Timestamps.getDaysPerMonth(this.startMonth, leap)) - 1;
        return Timestamps.yearMicros(y + bucket, leap) + Timestamps.monthOfYearMicros(this.startMonth, leap) + (long)maxDay * 86400000000L + (long)this.startHour * 3600000000L + (long)this.startMin * 60000000L + (long)this.startSec * 1000000L + (long)this.startMillis * 1000L + (long)this.startMicros;
    }
}

