/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.groupby.InterpolationGroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByFillRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillValueRecordCursorFactory
extends AbstractSampleByFillRecordCursorFactory {
    private final AbstractNoRecordSampleByCursor cursor;

    public SampleByFillValueRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ObjList<ExpressionNode> fillValues, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList recordFunctionPositions, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) throws SqlException {
        super(configuration, base, listColumnFilter, asm, keyTypes, valueTypes, groupByMetadata, groupByFunctions, recordFunctions);
        try {
            ObjList<Function> placeholderFunctions = SampleByFillValueRecordCursorFactory.createPlaceholderFunctions(groupByFunctions, recordFunctions, recordFunctionPositions, fillValues, false);
            this.cursor = new SampleByFillValueRecordCursor(this.map, this.mapSink, groupByFunctions, recordFunctions, placeholderFunctions, timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            Misc.free(this.map);
            throw e;
        }
    }

    @NotNull
    static ObjList<Function> createPlaceholderFunctions(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList recordFunctionPositions, @NotNull ObjList<ExpressionNode> fillValues, boolean linearSupported) throws SqlException {
        ObjList<Function> placeholderFunctions = new ObjList<Function>();
        int fillIndex = 0;
        int fillValueCount = fillValues.size();
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function function = recordFunctions.getQuick(i);
            if (function instanceof GroupByFunction) {
                if (fillIndex == fillValueCount) {
                    throw SqlException.position(0).put("not enough values");
                }
                ExpressionNode fillNode = fillValues.getQuick(fillIndex++);
                if (SqlKeywords.isNullKeyword(fillNode.token)) {
                    placeholderFunctions.add(SampleByFillNullRecordCursorFactory.createPlaceHolderFunction(recordFunctionPositions, i, function.getType()));
                    continue;
                }
                if (SqlKeywords.isPrevKeyword(fillNode.token)) {
                    placeholderFunctions.add(function);
                    continue;
                }
                if (SqlKeywords.isLinearKeyword(fillNode.token)) {
                    if (!linearSupported) {
                        throw SqlException.position(0).put("linear interpolation is not supported when using fill values for keyed sample by expression");
                    }
                    InterpolationGroupByFunction interpolation = InterpolationGroupByFunction.newInstance((GroupByFunction)function);
                    placeholderFunctions.add(interpolation);
                    groupByFunctions.set(fillIndex - 1, interpolation);
                    recordFunctions.set(i, interpolation);
                    continue;
                }
                placeholderFunctions.add(SampleByFillValueRecordCursorFactory.createPlaceHolderFunction(recordFunctionPositions, i, function.getType(), fillNode));
                continue;
            }
            placeholderFunctions.add(function);
        }
        return placeholderFunctions;
    }

    static Function createPlaceHolderFunction(IntList recordFunctionPositions, int index, int type, ExpressionNode fillNode) throws SqlException {
        try {
            switch (ColumnType.tagOf(type)) {
                case 5: {
                    return IntConstant.newInstance(Numbers.parseInt(fillNode.token));
                }
                case 6: {
                    return LongConstant.newInstance(Numbers.parseLong(fillNode.token));
                }
                case 9: {
                    return FloatConstant.newInstance(Numbers.parseFloat(fillNode.token));
                }
                case 10: {
                    return DoubleConstant.newInstance(Numbers.parseDouble(fillNode.token));
                }
                case 3: {
                    return ShortConstant.newInstance((short)Numbers.parseInt(fillNode.token));
                }
                case 2: {
                    return ByteConstant.newInstance((byte)Numbers.parseInt(fillNode.token));
                }
            }
            throw SqlException.$(recordFunctionPositions.getQuick(index), "Unsupported type: ").put(ColumnType.nameOf(type));
        }
        catch (NumericException e) {
            throw SqlException.position(fillNode.position).put("invalid number: ").put(fillNode.token);
        }
    }

    @Override
    protected AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

