/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractSplitVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillValueRecordCursor
extends AbstractSplitVirtualRecordSampleByCursor
implements Reopenable {
    private final Map map;
    private final RecordSink keyMapSink;
    private final RecordCursor mapCursor;
    private final Record mapRecord;
    private boolean isOpen;

    public SampleByFillValueRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, int timestampIndex, TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions, placeholderFunctions, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.record.of(map.getRecord());
        this.mapCursor = map.getCursor();
        this.mapRecord = map.getRecord();
        this.isOpen = true;
    }

    @Override
    public boolean hasNext() {
        block9: {
            long timestamp;
            if (this.mapCursor.hasNext()) {
                return this.refreshRecord();
            }
            if (this.baseRecord == null) {
                return false;
            }
            long expectedLocalEpoch = this.timestampSampler.nextTimestamp(this.nextSampleLocalEpoch);
            if (expectedLocalEpoch < this.localEpoch) {
                this.sampleLocalEpoch = expectedLocalEpoch;
                this.nextSampleLocalEpoch = expectedLocalEpoch;
                return this.refreshMapCursor();
            }
            long next = this.timestampSampler.nextTimestamp(this.localEpoch);
            this.sampleLocalEpoch = this.localEpoch;
            this.nextSampleLocalEpoch = this.localEpoch;
            int n = this.groupByFunctions.size();
            while ((timestamp = this.getBaseRecordTimestamp()) < next) {
                this.adjustDSTInFlight(timestamp - this.tzOffset);
                MapKey key = this.map.withKey();
                this.keyMapSink.copy(this.baseRecord, key);
                MapValue value = key.findValue();
                assert (value != null);
                if (value.getLong(0) != this.localEpoch) {
                    value.putLong(0, this.localEpoch);
                    GroupByUtils.updateNew(this.groupByFunctions, n, value, this.baseRecord);
                } else {
                    GroupByUtils.updateExisting(this.groupByFunctions, n, value, this.baseRecord);
                }
                if (this.base.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    continue;
                }
                this.baseRecord = null;
                break block9;
            }
            if ((timestamp = this.adjustDST(timestamp, n, null, next)) != Long.MIN_VALUE) {
                this.nextSamplePeriod(timestamp);
            }
        }
        return this.refreshMapCursor();
    }

    @Override
    public void reopen() {
        if (!this.isOpen) {
            this.map.reopen();
            this.isOpen = true;
        }
    }

    @Override
    protected void updateValueWhenClockMovesBack(MapValue value, int n) {
        MapKey key = this.map.withKey();
        this.keyMapSink.copy(this.baseRecord, key);
        super.updateValueWhenClockMovesBack(key.createValue(), n);
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            int n = this.groupByFunctions.size();
            RecordCursor mapCursor = this.map.getCursor();
            MapRecord mapRecord = this.map.getRecord();
            while (mapCursor.hasNext()) {
                MapValue value = mapRecord.getValue();
                value.putLong(0, Long.MIN_VALUE);
                for (int i = 0; i < n; ++i) {
                    ((GroupByFunction)this.groupByFunctions.getQuick(i)).setNull(value);
                }
            }
        }
    }

    private boolean refreshMapCursor() {
        this.map.getCursor().hasNext();
        return this.refreshRecord();
    }

    private boolean refreshRecord() {
        if (this.mapRecord.getTimestamp(0) == this.sampleLocalEpoch) {
            this.record.setActiveA();
        } else {
            this.record.setActiveB();
        }
        return true;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.map.close();
            super.close();
            this.isOpen = false;
        }
    }
}

