/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.GeoByteConstant;
import io.questdb.griffin.engine.functions.constants.GeoIntConstant;
import io.questdb.griffin.engine.functions.constants.GeoLongConstant;
import io.questdb.griffin.engine.functions.constants.GeoShortConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByFillRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNullRecordCursorFactory
extends AbstractSampleByFillRecordCursorFactory {
    private final AbstractNoRecordSampleByCursor cursor;

    public SampleByFillNullRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, @NotNull IntList recordFunctionPositions, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) throws SqlException {
        super(configuration, base, listColumnFilter, asm, keyTypes, valueTypes, groupByMetadata, groupByFunctions, recordFunctions);
        try {
            this.cursor = new SampleByFillValueRecordCursor(this.map, this.mapSink, groupByFunctions, recordFunctions, SampleByFillNullRecordCursorFactory.createPlaceholderFunctions(recordFunctions, recordFunctionPositions), timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            Misc.free(this.map);
            throw e;
        }
    }

    @NotNull
    static ObjList<Function> createPlaceholderFunctions(ObjList<Function> recordFunctions, IntList recordFunctionPositions) throws SqlException {
        ObjList<Function> placeholderFunctions = new ObjList<Function>();
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function function = recordFunctions.getQuick(i);
            if (function instanceof GroupByFunction) {
                placeholderFunctions.add(SampleByFillNullRecordCursorFactory.createPlaceHolderFunction(recordFunctionPositions, i, function.getType()));
                continue;
            }
            placeholderFunctions.add(function);
        }
        return placeholderFunctions;
    }

    static Function createPlaceHolderFunction(IntList recordFunctionPositions, int index, int type) throws SqlException {
        switch (ColumnType.tagOf(type)) {
            case 5: {
                return IntConstant.NULL;
            }
            case 6: {
                return LongConstant.NULL;
            }
            case 9: {
                return FloatConstant.NULL;
            }
            case 10: {
                return DoubleConstant.NULL;
            }
            case 2: {
                return ByteConstant.ZERO;
            }
            case 3: {
                return ShortConstant.ZERO;
            }
            case 14: {
                return GeoByteConstant.NULL;
            }
            case 15: {
                return GeoShortConstant.NULL;
            }
            case 16: {
                return GeoIntConstant.NULL;
            }
            case 17: {
                return GeoLongConstant.NULL;
            }
        }
        throw SqlException.$(recordFunctionPositions.getQuick(index), "Unsupported type: ").put(ColumnType.nameOf(type));
    }

    @Override
    public AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

