/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableNoSizeRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNoneRecordCursorFactory
extends AbstractSampleByRecordCursorFactory {
    private final SampleByFillNoneRecordCursor cursor;

    public SampleByFillNoneRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata groupByMetadata, @NotNull ObjList<GroupByFunction> groupByFunctions, @NotNull ObjList<Function> recordFunctions, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(base, groupByMetadata, recordFunctions);
        RecordSink mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        Map map = MapFactory.createSmallMap(configuration, keyTypes, valueTypes);
        this.cursor = new SampleByFillNoneRecordCursor(map, mapSink, groupByFunctions, this.recordFunctions, timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
    }

    @Override
    protected void _close() {
        this.cursor.close();
        super._close();
    }

    @Override
    public AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            if (baseCursor.hasNext()) {
                return this.initFunctionsAndCursor(executionContext, baseCursor);
            }
            Misc.free(baseCursor);
            Misc.free(this.cursor);
            return EmptyTableNoSizeRecordCursor.INSTANCE;
        }
        catch (Throwable ex) {
            Misc.free(baseCursor);
            Misc.free(this.cursor);
            throw ex;
        }
    }
}

