/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class MapSymbolColumn
extends SymbolFunction {
    private final int mapColumnIndex;
    private final int cursorColumnIndex;
    private final boolean symbolTableStatic;
    private SymbolTable symbolTable;
    private SymbolTableSource symbolTableSource;
    private boolean ownSymbolTable;

    public MapSymbolColumn(int mapColumnIndex, int cursorColumnIndex, boolean symbolTableStatic) {
        this.mapColumnIndex = mapColumnIndex;
        this.cursorColumnIndex = cursorColumnIndex;
        this.symbolTableStatic = symbolTableStatic;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.mapColumnIndex);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.symbolTable.valueOf(this.getInt(rec));
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.symbolTable.valueBOf(this.getInt(rec));
    }

    @Override
    @Nullable
    public StaticSymbolTable getStaticSymbolTable() {
        return this.symbolTable instanceof StaticSymbolTable ? (StaticSymbolTable)this.symbolTable : null;
    }

    @Override
    @Nullable
    public SymbolTable newSymbolTable() {
        return this.symbolTableSource.newSymbolTable(this.cursorColumnIndex);
    }

    @Override
    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.symbolTableSource = symbolTableSource;
        if (executionContext.getCloneSymbolTables()) {
            if (this.symbolTable != null) {
                assert (this.ownSymbolTable);
                this.symbolTable = Misc.free(this.symbolTable);
            }
            this.symbolTable = symbolTableSource.newSymbolTable(this.cursorColumnIndex);
            this.ownSymbolTable = true;
        } else {
            this.symbolTable = symbolTableSource.getSymbolTable(this.cursorColumnIndex);
            this.ownSymbolTable = false;
        }
        assert (this.symbolTable != this);
        assert (this.symbolTable != null);
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbolTable.valueOf(symbolKey);
    }

    @Override
    public CharSequence valueBOf(int symbolKey) {
        return this.symbolTable.valueBOf(symbolKey);
    }

    @Override
    public void close() {
        if (this.ownSymbolTable) {
            this.symbolTable = Misc.free(this.symbolTable);
        }
    }
}

