/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.VirtualFunctionSkewedSymbolRecordCursor;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final GroupByRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final RecordSink mapSink;

    public GroupByRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions) {
        super(groupByMetadata);
        try {
            this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
            this.base = base;
            this.groupByFunctions = groupByFunctions;
            this.recordFunctions = recordFunctions;
            this.cursor = new GroupByRecordCursor(recordFunctions, keyTypes, valueTypes, configuration);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.base);
        Misc.free(this.cursor);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Function.init(this.recordFunctions, baseCursor, executionContext);
            this.cursor.of(baseCursor, circuitBreaker);
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupByRecord");
        sink.meta("vectorized").val(false);
        sink.attr("groupByFunctions").val(this.groupByFunctions);
        sink.attr("recordFunctions").val(this.recordFunctions);
        sink.child(this.base);
    }

    class GroupByRecordCursor
    extends VirtualFunctionSkewedSymbolRecordCursor {
        private final Map dataMap;
        private boolean isOpen;

        public GroupByRecordCursor(@NotNull ObjList<Function> functions, @NotNull ArrayColumnTypes keyTypes, ArrayColumnTypes valueTypes, CairoConfiguration configuration) {
            super(functions);
            this.dataMap = MapFactory.createMap(configuration, keyTypes, valueTypes);
            this.isOpen = true;
        }

        public void of(RecordCursor baseCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            try {
                if (!this.isOpen) {
                    this.isOpen = true;
                    this.dataMap.reopen();
                }
                Record baseRecord = baseCursor.getRecord();
                int n = GroupByRecordCursorFactory.this.groupByFunctions.size();
                while (baseCursor.hasNext()) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    MapKey key = this.dataMap.withKey();
                    GroupByRecordCursorFactory.this.mapSink.copy(baseRecord, key);
                    MapValue value = key.createValue();
                    GroupByUtils.updateFunctions(GroupByRecordCursorFactory.this.groupByFunctions, n, value, baseRecord);
                }
                super.of(baseCursor, this.dataMap.getCursor());
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.dataMap);
                Misc.clearObjList(GroupByRecordCursorFactory.this.groupByFunctions);
                super.close();
            }
        }
    }
}

