/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class GroupByNotKeyedRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final GroupByNotKeyedRecordCursor cursor;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final SimpleMapValue simpleMapValue;
    private final VirtualRecord virtualRecordA;

    public GroupByNotKeyedRecordCursorFactory(RecordCursorFactory base, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount) {
        super(groupByMetadata);
        this.simpleMapValue = new SimpleMapValue(valueCount);
        this.base = base;
        this.groupByFunctions = groupByFunctions;
        this.virtualRecordA = new VirtualRecordNoRowid(recordFunctions);
        this.virtualRecordA.of(this.simpleMapValue);
        this.cursor = new GroupByNotKeyedRecordCursor();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.groupByFunctions);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            return this.cursor.of(baseCursor, executionContext);
        }
        catch (Throwable e) {
            Misc.free(baseCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupByNotKeyed");
        sink.meta("vectorized").val(false);
        sink.attr("groupByFunctions").val(this.groupByFunctions);
        sink.child(this.base);
    }

    private class GroupByNotKeyedRecordCursor
    implements NoRandomAccessRecordCursor {
        private RecordCursor baseCursor;
        private int recordsRemaining = 1;

        private GroupByNotKeyedRecordCursor() {
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            Misc.clearObjList(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return (SymbolTable)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return ((SymbolFunction)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex)).newSymbolTable();
        }

        @Override
        public void toTop() {
            this.recordsRemaining = 1;
            GroupByUtils.toTop(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }

        @Override
        public Record getRecord() {
            return GroupByNotKeyedRecordCursorFactory.this.virtualRecordA;
        }

        @Override
        public boolean hasNext() {
            return this.recordsRemaining-- > 0;
        }

        RecordCursor of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            this.baseCursor = baseCursor;
            SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
            Record baseRecord = baseCursor.getRecord();
            int n = GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.size();
            Function.init(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, baseCursor, executionContext);
            if (baseCursor.hasNext()) {
                GroupByUtils.updateNew(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, n, GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord);
                while (baseCursor.hasNext()) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    GroupByUtils.updateExisting(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, n, GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord);
                }
            } else {
                GroupByUtils.updateEmpty(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, n, GroupByNotKeyedRecordCursorFactory.this.simpleMapValue);
            }
            this.toTop();
            return this;
        }

        @Override
        public long size() {
            return 1L;
        }
    }
}

