/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DistinctTimeSeriesRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final DistinctTimeSeriesRecordCursor cursor;
    public static final byte COMPUTE_NEXT = 0;
    public static final byte REUSE_CURRENT = 1;
    public static final byte NO_ROWS = 2;

    public DistinctTimeSeriesRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull EntityColumnFilter columnFilter, @NotNull BytecodeAssembler asm) {
        super(base.getMetadata());
        assert (base.recordCursorSupportsRandomAccess());
        RecordMetadata metadata = base.getMetadata();
        columnFilter.of(metadata.getColumnCount());
        RecordSink recordSink = RecordSinkFactory.getInstance(asm, metadata, columnFilter, false);
        FastMap dataMap = new FastMap(configuration.getSqlMapPageSize(), metadata, configuration.getSqlDistinctTimestampKeyCapacity(), configuration.getSqlDistinctTimestampLoadFactor(), Integer.MAX_VALUE);
        this.base = base;
        this.cursor = new DistinctTimeSeriesRecordCursor(this.getMetadata().getTimestampIndex(), dataMap, recordSink);
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        return this.cursor.of(this.base.getCursor(executionContext), executionContext);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.base.hasDescendingOrder();
    }

    private static class DistinctTimeSeriesRecordCursor
    implements RecordCursor {
        private final Map dataMap;
        private final RecordSink recordSink;
        private final int timestampIndex;
        private RecordCursor baseCursor;
        private Record record;
        private Record recordB;
        private long prevTimestamp;
        private long prevRowId;
        private byte state = 0;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;

        public DistinctTimeSeriesRecordCursor(int timestampIndex, Map dataMap, RecordSink recordSink) {
            this.timestampIndex = timestampIndex;
            this.dataMap = dataMap;
            this.recordSink = recordSink;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.baseCursor);
                Misc.free(this.dataMap);
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (this.state == 0) {
                while (this.baseCursor.hasNext()) {
                    this.circuitBreaker.statefulThrowExceptionIfTripped();
                    long timestamp = this.record.getTimestamp(this.timestampIndex);
                    if (timestamp != this.prevTimestamp) {
                        this.prevTimestamp = timestamp;
                        this.prevRowId = this.record.getRowId();
                        return true;
                    }
                    if (!this.checkIfNotDupe()) continue;
                    return true;
                }
                return false;
            }
            boolean next = this.state == 1;
            this.state = 0;
            return next;
        }

        @Override
        public Record getRecordB() {
            return this.baseCursor.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(record, atRowId);
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.dataMap.clear();
        }

        @Override
        public long size() {
            return -1L;
        }

        public RecordCursor of(RecordCursor baseCursor, SqlExecutionContext sqlExecutionContext) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.dataMap.reopen();
            }
            this.baseCursor = baseCursor;
            this.circuitBreaker = sqlExecutionContext.getCircuitBreaker();
            this.record = baseCursor.getRecord();
            this.recordB = baseCursor.getRecordB();
            if (baseCursor.hasNext()) {
                this.prevTimestamp = this.record.getTimestamp(this.timestampIndex);
                this.prevRowId = this.record.getRowId();
                this.state = 1;
            } else {
                this.state = (byte)2;
            }
            return this;
        }

        private boolean checkIfNotDupe() {
            MapKey key;
            if (this.prevRowId != -1L) {
                this.baseCursor.recordAt(this.recordB, this.prevRowId);
                this.dataMap.clear();
                key = this.dataMap.withKey();
                this.recordSink.copy(this.recordB, key);
                key.create();
                this.prevRowId = -1L;
            }
            key = this.dataMap.withKey();
            this.recordSink.copy(this.record, key);
            return key.create();
        }
    }
}

