/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DistinctRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final DistinctRecordCursor cursor;
    private final RecordSink mapSink;

    public DistinctRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull EntityColumnFilter columnFilter, @NotNull BytecodeAssembler asm) {
        super(base.getMetadata());
        RecordMetadata metadata = base.getMetadata();
        columnFilter.of(metadata.getColumnCount());
        this.mapSink = RecordSinkFactory.getInstance(asm, metadata, columnFilter, false);
        this.base = base;
        this.cursor = new DistinctRecordCursor(configuration, metadata);
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, this.mapSink, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private static class DistinctRecordCursor
    implements RecordCursor {
        private RecordCursor baseCursor;
        private final Map dataMap;
        private RecordSink recordSink;
        private Record record;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;

        public DistinctRecordCursor(CairoConfiguration configuration, RecordMetadata metadata) {
            this.dataMap = MapFactory.createMap(configuration, metadata);
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.baseCursor);
                Misc.free(this.dataMap);
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.dataMap.withKey();
                this.recordSink.copy(this.record, key);
                if (!key.create()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Record getRecordB() {
            return this.baseCursor.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(record, atRowId);
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.dataMap.clear();
        }

        public void of(RecordCursor baseCursor, RecordSink recordSink, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.dataMap.reopen();
            }
            this.baseCursor = baseCursor;
            this.recordSink = recordSink;
            this.record = baseCursor.getRecord();
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public long size() {
            return -1L;
        }
    }
}

