/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableNoSizeRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByRecordCursorFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSampleByFillRecordCursorFactory
extends AbstractSampleByRecordCursorFactory {
    protected final Map map;
    protected final ObjList<GroupByFunction> groupByFunctions;
    protected final RecordSink mapSink;

    public AbstractSampleByFillRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions) {
        super(base, groupByMetadata, recordFunctions);
        this.groupByFunctions = groupByFunctions;
        this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
        this.map = MapFactory.createMap(configuration, keyTypes, valueTypes);
    }

    @Override
    protected void _close() {
        super._close();
        this.getRawCursor().close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        AbstractNoRecordSampleByCursor rawCursor = null;
        try {
            rawCursor = this.getRawCursor();
            if (rawCursor instanceof Reopenable) {
                ((Reopenable)((Object)rawCursor)).reopen();
            }
            int n = this.groupByFunctions.size();
            Record baseCursorRecord = baseCursor.getRecord();
            while (baseCursor.hasNext()) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.map.withKey();
                this.mapSink.copy(baseCursorRecord, key);
                MapValue value = key.createValue();
                if (!value.isNew()) continue;
                value.putLong(0, Long.MIN_VALUE);
                for (int i = 0; i < n; ++i) {
                    this.groupByFunctions.getQuick(i).setNull(value);
                }
            }
            if (this.map.size() == 0L) {
                baseCursor.close();
                rawCursor.close();
                return EmptyTableNoSizeRecordCursor.INSTANCE;
            }
            baseCursor.toTop();
            boolean next = baseCursor.hasNext();
            assert (next);
            return this.initFunctionsAndCursor(executionContext, baseCursor);
        }
        catch (Throwable ex) {
            baseCursor.close();
            Misc.free(rawCursor);
            throw ex;
        }
    }
}

