/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.AbstractSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNoRecordSampleByCursor
extends AbstractSampleByCursor {
    protected final int timestampIndex;
    protected final ObjList<GroupByFunction> groupByFunctions;
    private final ObjList<Function> recordFunctions;
    protected Record baseRecord;
    protected long sampleLocalEpoch;
    protected long nextSampleLocalEpoch;
    protected RecordCursor base;
    protected SqlExecutionCircuitBreaker circuitBreaker;
    protected long topTzOffset;
    private long topNextDst;
    private long topLocalEpoch;

    public AbstractNoRecordSampleByCursor(ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, ObjList<GroupByFunction> groupByFunctions, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos) {
        super(timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos);
        this.timestampIndex = timestampIndex;
        this.recordFunctions = recordFunctions;
        this.groupByFunctions = groupByFunctions;
    }

    @Override
    public void close() {
        Misc.free(this.base);
        Misc.clearObjList(this.groupByFunctions);
        this.circuitBreaker = null;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.recordFunctions.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)this.recordFunctions.getQuick(columnIndex)).newSymbolTable();
    }

    @Override
    public void toTop() {
        GroupByUtils.toTop(this.recordFunctions);
        this.base.toTop();
        this.localEpoch = this.topLocalEpoch;
        this.sampleLocalEpoch = this.nextSampleLocalEpoch = this.topLocalEpoch;
        this.tzOffset = this.topTzOffset;
        this.prevDst = Long.MIN_VALUE;
        this.nextDstUTC = this.topNextDst;
    }

    @Override
    public long size() {
        return -1L;
    }

    public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        this.prevDst = Long.MIN_VALUE;
        this.parseParams(base, executionContext);
        this.base = base;
        this.baseRecord = base.getRecord();
        long timestamp = this.baseRecord.getTimestamp(this.timestampIndex);
        if (this.rules != null) {
            this.tzOffset = this.rules.getOffset(timestamp);
            this.nextDstUTC = this.rules.getNextDST(timestamp);
        }
        if (this.tzOffset == 0L && this.fixedOffset == Long.MIN_VALUE) {
            this.timestampSampler.setStart(timestamp);
        } else {
            this.timestampSampler.setStart(this.fixedOffset != Long.MIN_VALUE ? this.fixedOffset : 0L);
        }
        this.topTzOffset = this.tzOffset;
        this.topNextDst = this.nextDstUTC;
        this.topLocalEpoch = this.localEpoch = this.timestampSampler.round(timestamp + this.tzOffset);
        this.sampleLocalEpoch = this.nextSampleLocalEpoch = this.localEpoch;
        this.circuitBreaker = executionContext.getCircuitBreaker();
    }

    protected long adjustDST(long timestamp, int n, @Nullable MapValue mapValue, long nextSampleTimestamp) {
        long utcTimestamp = timestamp - this.tzOffset;
        if (utcTimestamp < this.nextDstUTC) {
            return timestamp;
        }
        long newTzOffset = this.rules.getOffset(utcTimestamp);
        this.prevDst = this.nextDstUTC;
        this.nextDstUTC = this.rules.getNextDST(utcTimestamp);
        if (timestamp - (this.tzOffset - newTzOffset) < nextSampleTimestamp) {
            this.updateValueWhenClockMovesBack(mapValue, n);
            this.localEpoch = this.nextSampleLocalEpoch = this.timestampSampler.round(timestamp);
            this.sampleLocalEpoch += newTzOffset - this.tzOffset;
            this.tzOffset = newTzOffset;
            return Long.MIN_VALUE;
        }
        this.kludge(newTzOffset);
        return utcTimestamp + newTzOffset;
    }

    protected void adjustDSTInFlight(long t) {
        if (t < this.nextDstUTC) {
            return;
        }
        long daylightSavings = this.rules.getOffset(t);
        this.prevDst = this.nextDstUTC;
        this.nextDstUTC = this.rules.getNextDST(t);
        this.kludge(daylightSavings);
    }

    protected long getBaseRecordTimestamp() {
        return this.baseRecord.getTimestamp(this.timestampIndex) + this.tzOffset;
    }

    private void kludge(long newTzOffset) {
        this.sampleLocalEpoch += newTzOffset - this.tzOffset;
        this.nextSampleLocalEpoch = this.sampleLocalEpoch;
        this.tzOffset = newTzOffset;
    }

    protected void nextSamplePeriod(long timestamp) {
        this.localEpoch = this.timestampSampler.round(timestamp);
        if (this.localEpoch - this.tzOffset < this.prevDst) {
            this.localEpoch += this.tzOffset;
        }
        GroupByUtils.toTop(this.groupByFunctions);
    }

    protected boolean notKeyedLoop(MapValue mapValue) {
        long next = this.timestampSampler.nextTimestamp(this.localEpoch);
        this.sampleLocalEpoch = this.localEpoch;
        this.nextSampleLocalEpoch = this.localEpoch;
        int n = this.groupByFunctions.size();
        GroupByUtils.updateNew(this.groupByFunctions, n, mapValue, this.baseRecord);
        while (this.base.hasNext()) {
            long timestamp = this.getBaseRecordTimestamp();
            if (timestamp < next) {
                this.adjustDSTInFlight(timestamp - this.tzOffset);
                GroupByUtils.updateExisting(this.groupByFunctions, n, mapValue, this.baseRecord);
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                continue;
            }
            if ((timestamp = this.adjustDST(timestamp, n, mapValue, next)) == Long.MIN_VALUE) continue;
            this.nextSamplePeriod(timestamp);
            return true;
        }
        this.baseRecord = null;
        return true;
    }

    protected void updateValueWhenClockMovesBack(MapValue value, int n) {
        GroupByUtils.updateExisting(this.groupByFunctions, n, value, this.baseRecord);
    }

    protected class TimestampFunc
    extends TimestampFunction
    implements Function {
        protected TimestampFunc() {
        }

        @Override
        public long getTimestamp(Record rec) {
            return AbstractNoRecordSampleByCursor.this.sampleLocalEpoch - AbstractNoRecordSampleByCursor.this.tzOffset;
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }
    }
}

