/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class ToCharBinFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_char(U)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new ToCharBinFunc(args.getQuick(0));
    }

    private static class ToCharBinFunc
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sink1 = new StringSink();
        private final StringSink sink2 = new StringSink();

        public ToCharBinFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.toSink(rec, this.sink1);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.toSink(rec, this.sink2);
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            Chars.toSink(this.arg.getBin(rec), sink);
        }

        @Override
        public int getStrLen(Record rec) {
            BinarySequence sequence = this.arg.getBin(rec);
            if (sequence == null) {
                return -1;
            }
            int len = (int)sequence.length();
            int incompleteLine = len % 16;
            int count = len / 16 * 57;
            count = incompleteLine > 0 ? (count += incompleteLine * 2 + incompleteLine + 8) : --count;
            return count;
        }

        @Nullable
        private CharSequence toSink(Record rec, StringSink sink) {
            BinarySequence sequence = this.arg.getBin(rec);
            if (sequence == null) {
                return null;
            }
            sink.clear();
            Chars.toSink(sequence, sink);
            return sink;
        }
    }
}

