/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.rnd.RndStringMemory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndStringRndListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_str(iiii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int count = args.getQuick(0).getInt(null);
        int lo = args.getQuick(1).getInt(null);
        int hi = args.getQuick(2).getInt(null);
        int nullRate = args.getQuick(3).getInt(null);
        if (count < 1) {
            throw SqlException.$(argPositions.getQuick(0), "invalid string count");
        }
        if (lo > hi || lo < 1) {
            throw SqlException.$(position, "invalid range");
        }
        if (nullRate < 0) {
            throw SqlException.position(argPositions.getQuick(3)).put("null rate must be positive");
        }
        RndStringMemory strMem = new RndStringMemory(this.getSignature(), count, lo, hi, argPositions.getQuick(0), configuration);
        return new Func(strMem, count, nullRate);
    }

    private static final class Func
    extends StrFunction
    implements Function {
        private final int count;
        private final RndStringMemory strMem;
        private final int nullRate;
        private Rnd rnd;

        public Func(RndStringMemory strMem, int count, int nullRate) {
            this.count = count;
            this.strMem = strMem;
            this.nullRate = nullRate;
        }

        @Override
        public void close() {
            this.strMem.close();
        }

        @Override
        public CharSequence getStr(Record rec) {
            if (this.nullRate > 0 && this.rnd.nextPositiveInt() % this.nullRate == 0) {
                return null;
            }
            return this.strMem.getStr(this.rnd.nextPositiveInt() % this.count);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            if (this.nullRate > 0 && this.rnd.nextPositiveInt() % this.nullRate == 0) {
                return null;
            }
            return this.strMem.getStr2(this.rnd.nextPositiveInt() % this.count);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
            this.strMem.init(this.rnd);
        }
    }
}

