/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryAR;
import io.questdb.griffin.SqlException;
import io.questdb.std.Misc;
import io.questdb.std.Rnd;
import java.io.Closeable;

class RndStringMemory
implements Closeable {
    private final MemoryAR strMem;
    private final MemoryAR idxMem;
    private final int count;
    private final int lo;
    private final int hi;

    RndStringMemory(String signature, int count, int lo, int hi, int position, CairoConfiguration configuration) throws SqlException {
        this.count = count;
        this.lo = lo;
        this.hi = hi;
        int pageSize = configuration.getRndFunctionMemoryPageSize();
        int maxPages = configuration.getRndFunctionMemoryMaxPages();
        long memLimit = (long)maxPages * (long)pageSize;
        long requiredMem = (long)count * (Vm.getStorageLength(hi) + 8L);
        if (requiredMem > memLimit) {
            throw SqlException.position(position).put("breached memory limit set for ").put(signature).put(" [pageSize=").put(pageSize).put(", maxPages=").put(maxPages).put(", memLimit=").put(memLimit).put(", requiredMem=").put(requiredMem).put(']');
        }
        int idxPages = count * 8 / pageSize + 1;
        this.strMem = Vm.getARInstance(pageSize, maxPages - idxPages, 1);
        this.idxMem = Vm.getARInstance(pageSize, idxPages, 1);
    }

    @Override
    public void close() {
        Misc.free(this.strMem);
        Misc.free(this.idxMem);
    }

    CharSequence getStr(long index) {
        if (index < 0L) {
            return null;
        }
        return this.strMem.getStr(this.getStrAddress(index));
    }

    CharSequence getStr2(long index) {
        if (index < 0L) {
            return null;
        }
        return this.strMem.getStr2(this.getStrAddress(index));
    }

    private long getStrAddress(long index) {
        return this.idxMem.getLong(index * 8L);
    }

    void init(Rnd rnd) {
        this.strMem.jumpTo(0L);
        this.idxMem.jumpTo(0L);
        if (this.lo == this.hi) {
            this.initFixedLength(rnd);
        } else {
            this.initVariableLength(rnd);
        }
    }

    private void initFixedLength(Rnd rnd) {
        long storageLength = Vm.getStorageLength(this.lo);
        for (int i = 0; i < this.count; ++i) {
            long o = this.strMem.putStr(rnd.nextChars(this.lo));
            this.idxMem.putLong(o - storageLength);
        }
    }

    private void initVariableLength(Rnd rnd) {
        for (int i = 0; i < this.count; ++i) {
            int len = this.lo + rnd.nextPositiveInt() % (this.hi - this.lo + 1);
            long o = this.strMem.putStr(rnd.nextChars(len));
            this.idxMem.putLong(o - Vm.getStorageLength(len));
        }
    }
}

