/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndShortCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_short(ii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        short hi;
        short lo = (short)args.getQuick(0).getInt(null);
        if (lo < (hi = (short)args.getQuick(1).getInt(null))) {
            return new RndFunction(lo, hi);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends ShortFunction
    implements Function {
        private final short lo;
        private final short range;
        private Rnd rnd;

        public RndFunction(short lo, short hi) {
            this.lo = lo;
            this.range = (short)(hi - lo + 1);
        }

        @Override
        public short getShort(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (short)(this.lo - s % this.range);
            }
            return (short)(this.lo + s % this.range);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }
}

