/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GeoIntFunction;
import io.questdb.griffin.engine.functions.GeoLongFunction;
import io.questdb.griffin.engine.functions.GeoShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndGeoHashFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_geohash(i)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int bits = args.getQuick(0).getInt(null);
        if (bits < 1 || bits > ColumnType.GEO_HASH_MAX_BITS_LENGTH) {
            throw SqlException.$(argPositions.getQuick(0), "precision must be in [1..60] range");
        }
        int type = ColumnType.getGeoHashTypeWithBits(bits);
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new RndByteFunction(type);
            }
            case 15: {
                return new RndShortFunction(type);
            }
            case 16: {
                return new RndIntFunction(type);
            }
        }
        return new RndLongFunction(type);
    }

    private static class RndLongFunction
    extends GeoLongFunction
    implements Function {
        private final int bits;
        private Rnd rnd;

        public RndLongFunction(int type) {
            super(type);
            this.bits = ColumnType.getGeoHashBits(type);
        }

        @Override
        public long getGeoLong(Record rec) {
            return this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public short getGeoShort(Record rec) {
            return (byte)this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }

    private static class RndIntFunction
    extends GeoIntFunction
    implements Function {
        private final int bits;
        private Rnd rnd;

        public RndIntFunction(int type) {
            super(type);
            this.bits = ColumnType.getGeoHashBits(type);
        }

        @Override
        public int getGeoInt(Record rec) {
            return (int)this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public short getGeoShort(Record rec) {
            return (byte)this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }

    private static class RndShortFunction
    extends GeoShortFunction
    implements Function {
        private final int bits;
        private Rnd rnd;

        public RndShortFunction(int type) {
            super(type);
            this.bits = ColumnType.getGeoHashBits(type);
        }

        @Override
        public short getGeoShort(Record rec) {
            return (short)this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }

    private static class RndByteFunction
    extends GeoByteFunction
    implements Function {
        private final int bits;
        private Rnd rnd;

        public RndByteFunction(int type) {
            super(type);
            this.bits = ColumnType.getGeoHashBits(type);
        }

        @Override
        public byte getGeoByte(Record rec) {
            return (byte)this.rnd.nextGeoHash(this.bits);
        }

        @Override
        public boolean isReadThreadSafe() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }
}

