/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class BitwiseNotLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~(L)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new BitNotLongFunction(args.getQuick(0));
    }

    public static final class BitNotLongFunction
    extends LongFunction
    implements UnaryFunction {
        private final Function value;

        public BitNotLongFunction(Function value) {
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public long getLong(Record rec) {
            long val = this.value.getLong(rec);
            return val != Long.MIN_VALUE ? val ^ 0xFFFFFFFFFFFFFFFFL : Long.MIN_VALUE;
        }
    }
}

