/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class AbsShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "abs(E)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AbsFunction(args.getQuick(0));
    }

    private static class AbsFunction
    extends ShortFunction
    implements UnaryFunction {
        final Function function;

        public AbsFunction(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public short getShort(Record rec) {
            short value = this.function.getShort(rec);
            return (short)Math.abs(value);
        }
    }
}

