/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LtDoubleVVFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(DD)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new FuncVV(args.getQuick(0), args.getQuick(1));
    }

    private static class FuncVV
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public FuncVV(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated ? this.left.getDouble(rec) >= this.right.getDouble(rec) : this.left.getDouble(rec) < this.right.getDouble(rec);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

