/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MinFloatGroupByFunction
extends FloatFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinFloatGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putFloat(this.valueIndex, this.arg.getFloat(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        float min = mapValue.getFloat(this.valueIndex);
        float next = this.arg.getFloat(record);
        if (next < min || Float.isNaN(min)) {
            mapValue.putFloat(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
    }

    @Override
    public void setFloat(MapValue mapValue, float value) {
        mapValue.putFloat(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putFloat(this.valueIndex, Float.NaN);
    }

    @Override
    public float getFloat(Record rec) {
        return rec.getFloat(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("MinFloat(").put(this.arg).put(')');
    }
}

