/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class KSumDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction,
Sinkable {
    private final Function arg;
    private int valueIndex;

    public KSumDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            mapValue.putDouble(this.valueIndex, value);
            mapValue.putLong(this.valueIndex + 2, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putLong(this.valueIndex + 2, 0L);
        }
        mapValue.putDouble(this.valueIndex + 1, 0.0);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            double sum = mapValue.getDouble(this.valueIndex);
            double c = mapValue.getDouble(this.valueIndex + 1);
            double y = value - c;
            double t = sum + y;
            mapValue.putDouble(this.valueIndex, t);
            mapValue.putDouble(this.valueIndex + 1, t - sum - y);
            mapValue.addLong(this.valueIndex + 2, 1L);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 2, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putLong(this.valueIndex + 2, 0L);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getLong(this.valueIndex + 2) > 0L ? rec.getDouble(this.valueIndex) : Double.NaN;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("KSumDouble(").put(this.arg).put(')');
    }
}

