/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

class FirstGeoHashGroupByFunctionLong
extends GeoByteFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function function;
    protected int valueIndex;

    public FirstGeoHashGroupByFunctionLong(int type, Function function) {
        super(type);
        this.function = function;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putLong(this.valueIndex, this.function.getGeoLong(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
    }

    @Override
    public Function getArg() {
        return this.function;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setLong(mapValue, -1L);
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        return rec.getGeoLong(this.valueIndex);
    }
}

