/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CountSymbolGroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final ObjList<IntList> lists = new ObjList();
    private int valueIndex;
    private int setIndex;

    public CountSymbolGroupByFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public void clear() {
        this.lists.clear();
        this.setIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        IntList list;
        if (this.lists.size() <= this.setIndex) {
            list = new IntList();
            this.lists.extendAndSet(this.setIndex, list);
        } else {
            list = this.lists.getQuick(this.setIndex);
        }
        list.clear(0);
        mapValue.putInt(this.valueIndex + 1, this.setIndex);
        ++this.setIndex;
        int val = this.arg.getInt(record);
        if (val != Integer.MIN_VALUE) {
            list.extendAndSet(val, 1);
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        IntList set = this.lists.getQuick(mapValue.getInt(this.valueIndex + 1));
        int val = this.arg.getInt(record);
        if (val != Integer.MIN_VALUE) {
            if (val < set.size()) {
                if (set.getQuick(val) == 1) {
                    return;
                }
                set.setQuick(val, 1);
            } else {
                set.extendAndSet(val, 1);
            }
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }
}

