/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(NN)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new EqTimestampFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class EqTimestampFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public EqTimestampFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getTimestamp(rec) == this.right.getTimestamp(rec));
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

