/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqSymStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(KS)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function symFunc = args.getQuick(0);
        Function strFunc = args.getQuick(1);
        if (strFunc.isConstant()) {
            return this.createHalfConstantFunc(strFunc, symFunc);
        }
        return new Func(symFunc, strFunc);
    }

    private Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        CharSequence constValue = constFunc.getStr(null);
        SymbolFunction func = (SymbolFunction)varFunc;
        if (func.getStaticSymbolTable() != null) {
            return new ConstCheckColumnFunc(func, constValue);
        }
        if (constValue == null) {
            return new NullCheckFunc(varFunc);
        }
        if (func.isSymbolTableStatic()) {
            return new ConstSymIntCheckFunc(func, constValue);
        }
        return new ConstCheckFunc(func, constValue);
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence a = this.left.getSymbol(rec);
            CharSequence b = this.right.getStr(rec);
            if (a == null) {
                return this.negated != (b == null);
            }
            return this.negated != Chars.equalsNc(a, b);
        }
    }

    private static class ConstCheckColumnFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final CharSequence constant;
        private int valueIndex;

        public ConstCheckColumnFunc(SymbolFunction arg, CharSequence constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == this.valueIndex);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable symbolTable = this.arg.getStaticSymbolTable();
            assert (symbolTable != null);
            this.valueIndex = symbolTable.keyOf(this.constant);
        }

        @Override
        public boolean isConstant() {
            return this.valueIndex == -2;
        }
    }

    private static class ConstSymIntCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final CharSequence constant;
        private int valueIndex;
        private boolean exists;

        public ConstSymIntCheckFunc(SymbolFunction arg, CharSequence constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.exists && this.arg.getInt(rec) == this.valueIndex);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable staticSymbolTable = this.arg.getStaticSymbolTable();
            assert (staticSymbolTable != null) : "Static symbol table is null for func with static isSymbolTableStatic returning true";
            this.valueIndex = staticSymbolTable.keyOf(this.constant);
            this.exists = this.valueIndex != -2;
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequence constant;

        public ConstCheckFunc(Function arg, CharSequence constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.constant, this.arg.getSymbol(rec));
        }
    }

    private static class NullCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getSymbol(rec) == null);
        }
    }
}

