/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqStrCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(SA)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function charFunc = args.getQuick(1);
        if (ColumnType.isNull(strFunc.getType()) || ColumnType.isNull(charFunc.getType())) {
            return new Func(strFunc, charFunc);
        }
        if (strFunc.isConstant() && !charFunc.isConstant()) {
            CharSequence str = strFunc.getStr(null);
            if (str == null || str.length() != 1) {
                return new NegatedAwareBooleanConstantFunc();
            }
            return new ConstStrFunc(charFunc, str.charAt(0));
        }
        if (!strFunc.isConstant() && charFunc.isConstant()) {
            return new ConstChrFunc(strFunc, charFunc.getChar(null));
        }
        if (strFunc.isConstant() && charFunc.isConstant()) {
            return new ConstStrConstChrFunc(Chars.equalsNc(strFunc.getStr(null), charFunc.getChar(null)));
        }
        return new Func(strFunc, charFunc);
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function chrFunc;

        public Func(Function strFunc, Function chrFunc) {
            this.strFunc = strFunc;
            this.chrFunc = chrFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public Function getRight() {
            return this.chrFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.strFunc.getStr(rec), this.chrFunc.getChar(rec));
        }
    }

    private static class NegatedAwareBooleanConstantFunc
    extends NegatableBooleanFunction
    implements ConstantFunction {
        private NegatedAwareBooleanConstantFunc() {
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated;
        }
    }

    private static class ConstStrConstChrFunc
    extends NegatableBooleanFunction
    implements ConstantFunction {
        private final boolean equals;

        public ConstStrConstChrFunc(boolean equals) {
            this.equals = equals;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != this.equals;
        }
    }

    private static class ConstStrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function chrFunc;
        private final char chrConst;

        public ConstStrFunc(Function chrFunc, char chrConst) {
            this.chrFunc = chrFunc;
            this.chrConst = chrConst;
        }

        @Override
        public Function getArg() {
            return this.chrFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.chrFunc.getChar(rec) == this.chrConst);
        }
    }

    private static class ConstChrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function strFunc;
        private final char chrConst;

        public ConstChrFunc(Function strFunc, char chrConst) {
            this.strFunc = strFunc;
            this.chrConst = chrConst;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.strFunc.getStr(rec), this.chrConst);
        }
    }
}

