/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqGeoHashGeoHashFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(GG)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function geohash1 = args.getQuick(0);
        Function geohash2 = args.getQuick(1);
        int type1p = geohash1.getType();
        int type2p = geohash2.getType();
        if (ColumnType.isNull(type1p) && ColumnType.isNull(type2p)) {
            return BooleanConstant.of(true);
        }
        if (ColumnType.isNull(type1p)) {
            type1p = type2p;
            geohash1 = Constants.getNullConstant(type2p);
        }
        if (ColumnType.isNull(type2p)) {
            type2p = type1p;
            geohash2 = Constants.getNullConstant(type1p);
        }
        if (geohash1.isConstant()) {
            long hash1 = GeoHashes.getGeoLong(type1p, geohash1, null);
            if (geohash2.isConstant()) {
                long hash2 = GeoHashes.getGeoLong(type2p, geohash2, null);
                return BooleanConstant.of(type1p == type2p && hash1 == hash2 || hash1 == -1L && hash2 == -1L);
            }
            if (hash1 == -1L || type1p == type2p) {
                return this.createConstCheckFunc(geohash2, hash1, type1p);
            }
            return BooleanConstant.of(false);
        }
        if (geohash2.isConstant()) {
            long hash2 = GeoHashes.getGeoLong(type2p, geohash2, null);
            if (hash2 == -1L || type1p == type2p) {
                return this.createConstCheckFunc(geohash1, hash2, type1p);
            }
            return BooleanConstant.of(false);
        }
        if (type1p == type2p) {
            return this.crateBinaryFunc(geohash1, geohash2, type1p);
        }
        return BooleanConstant.of(false);
    }

    private Function crateBinaryFunc(final Function geohash1, final Function geohash2, int valType) {
        switch (ColumnType.tagOf(valType)) {
            case 14: {
                return new GeoEqFunc(geohash1, geohash2){

                    @Override
                    public boolean getBool(Record rec) {
                        return this.negated != (geohash1.getGeoByte(rec) == geohash2.getGeoByte(rec));
                    }
                };
            }
            case 15: {
                return new GeoEqFunc(geohash1, geohash2){

                    @Override
                    public boolean getBool(Record rec) {
                        return this.negated != (geohash1.getGeoShort(rec) == geohash2.getGeoShort(rec));
                    }
                };
            }
            case 16: {
                return new GeoEqFunc(geohash1, geohash2){

                    @Override
                    public boolean getBool(Record rec) {
                        return this.negated != (geohash1.getGeoInt(rec) == geohash2.getGeoInt(rec));
                    }
                };
            }
        }
        return new GeoEqFunc(geohash1, geohash2){

            @Override
            public boolean getBool(Record rec) {
                return this.negated != (geohash1.getGeoLong(rec) == geohash2.getGeoLong(rec));
            }
        };
    }

    private Function createConstCheckFunc(Function function, long value, int valType) {
        switch (ColumnType.tagOf(valType)) {
            case 14: {
                return new ConstCheckFuncByte(function, (byte)value);
            }
            case 15: {
                return new ConstCheckFuncShort(function, (short)value);
            }
            case 16: {
                return new ConstCheckFuncInt(function, (int)value);
            }
        }
        return new ConstCheckFuncLong(function, value);
    }

    private static abstract class GeoEqFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        protected final Function left;
        protected final Function right;

        public GeoEqFunc(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }

    private static class ConstCheckFuncLong
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final long hash;

        public ConstCheckFuncLong(Function arg, long hash) {
            this.arg = arg;
            this.hash = hash;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.hash == this.arg.getGeoLong(rec));
        }
    }

    private static class ConstCheckFuncInt
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final int hash;

        public ConstCheckFuncInt(Function arg, int hash) {
            this.arg = arg;
            this.hash = hash;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.hash == this.arg.getGeoInt(rec));
        }
    }

    private static class ConstCheckFuncShort
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final short hash;

        public ConstCheckFuncShort(Function arg, short hash) {
            this.arg = arg;
            this.hash = hash;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.hash == this.arg.getGeoShort(rec));
        }
    }

    private static class ConstCheckFuncByte
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final byte hash;

        public ConstCheckFuncByte(Function arg, byte hash) {
            this.arg = arg;
            this.hash = hash;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.hash == this.arg.getGeoByte(rec));
        }
    }
}

