/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(DD)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function left = args.getQuick(0);
        Function right = args.getQuick(1);
        int leftType = left.getType();
        int rightType = right.getType();
        if (EqDoubleFunctionFactory.isNullConstant(left, leftType)) {
            return EqDoubleFunctionFactory.dispatchUnaryFunc(right, rightType);
        }
        if (EqDoubleFunctionFactory.isNullConstant(right, rightType)) {
            return EqDoubleFunctionFactory.dispatchUnaryFunc(left, leftType);
        }
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static boolean isNullConstant(Function operand, int operandType) {
        return operand.isConstant() && (ColumnType.isDouble(operandType) && Double.isNaN(operand.getDouble(null)) || operandType == 28);
    }

    private static Function dispatchUnaryFunc(Function operand, int operandType) {
        switch (ColumnType.tagOf(operandType)) {
            case 5: {
                return new FuncIntIsNaN(operand);
            }
            case 6: {
                return new FuncLongIsNaN(operand);
            }
            case 7: {
                return new FuncDateIsNaN(operand);
            }
            case 8: {
                return new FuncTimestampIsNaN(operand);
            }
            case 9: {
                return new FuncFloatIsNaN(operand);
            }
        }
        return new FuncDoubleIsNaN(operand);
    }

    protected static class FuncDoubleIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncDoubleIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Double.isNaN(this.arg.getDouble(rec));
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncFloatIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncFloatIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Float.isNaN(this.arg.getFloat(rec));
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncTimestampIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncTimestampIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getTimestamp(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncDateIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncDateIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getDate(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncLongIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncLongIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getLong(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncIntIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncIntIsNaN(Function arg) {
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == Integer.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        protected final Function left;
        protected final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            double l = this.left.getDouble(rec);
            double r = this.right.getDouble(rec);
            return this.negated != (l != l && r != r || Math.abs(l - r) < 1.0E-10 || l == r);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

