/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.date.OffsetTimestampFunctionFromOffset;
import io.questdb.griffin.engine.functions.date.OffsetTimestampFunctionFromRules;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.NotNull;

public class ToUTCTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_utc(NS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function timestamp = args.getQuick(0);
        Function timezone = args.getQuick(1);
        if (timezone.isConstant()) {
            return ToUTCTimestampFunctionFactory.getTimestampFunction(argPositions, timestamp, timezone, -1);
        }
        return new ToTimezoneFunctionVar(timestamp, timezone);
    }

    @NotNull
    static TimestampFunction getTimestampFunction(IntList argPositions, Function timestamp, Function timezone, int multiplier) throws SqlException {
        CharSequence tz = timezone.getStr(null);
        if (tz != null) {
            int hi = tz.length();
            long l = Timestamps.parseOffset(tz, 0, hi);
            if (l == Long.MIN_VALUE) {
                try {
                    return new OffsetTimestampFunctionFromRules(timestamp, TimestampFormatUtils.enLocale.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.enLocale.matchZone(tz, 0, hi)), 1), multiplier);
                }
                catch (NumericException e) {
                    Misc.free(timestamp);
                    throw SqlException.$(argPositions.getQuick(1), "invalid timezone name");
                }
            }
            return new OffsetTimestampFunctionFromOffset(timestamp, (long)(multiplier * Numbers.decodeLowInt(l)) * 60000000L);
        }
        throw SqlException.$(argPositions.getQuick(1), "timezone must not be null");
    }

    private static class ToTimezoneFunctionVar
    extends TimestampFunction
    implements BinaryFunction {
        private final Function timestamp;
        private final Function timezone;

        public ToTimezoneFunctionVar(Function timestamp, Function timezone) {
            this.timestamp = timestamp;
            this.timezone = timezone;
        }

        @Override
        public Function getLeft() {
            return this.timestamp;
        }

        @Override
        public Function getRight() {
            return this.timezone;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestampValue = this.timestamp.getTimestamp(rec);
            try {
                CharSequence tz = this.timezone.getStr(rec);
                return tz != null ? Timestamps.toUTC(timestampValue, TimestampFormatUtils.enLocale, tz) : timestampValue;
            }
            catch (NumericException e) {
                return timestampValue;
            }
        }
    }
}

