/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class NowFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "now()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func();
    }

    private static class Func
    extends TimestampFunction
    implements Function {
        private SqlExecutionContext context;

        private Func() {
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.context.getNow();
        }

        @Override
        public boolean isRuntimeConstant() {
            return true;
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            executionContext.initNow();
            this.context = executionContext;
        }

        @Override
        public void toSink(CharSink sink) {
            sink.put("NowFunction");
        }
    }
}

