/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class AddLongToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(NL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AddLongFunc(args.getQuick(0), args.getQuick(1));
    }

    private static class AddLongFunc
    extends TimestampFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public AddLongFunc(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.left.getTimestamp(rec);
            long r = this.right.getLong(rec);
            if (l == Long.MIN_VALUE || r == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return l + r;
        }

        @Override
        public void toSink(CharSink sink) {
            sink.put("AddLongToTimestamp(").put(this.left).put(",").put(this.right).put(')');
        }
    }
}

