/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.str.CharSink;

public class LongConstant
extends LongFunction
implements ConstantFunction {
    public static final LongConstant NULL = new LongConstant(Long.MIN_VALUE);
    public static final LongConstant ZERO = new LongConstant(0L);
    private final long value;

    public LongConstant(long value) {
        this.value = value;
    }

    public static LongConstant newInstance(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value != Long.MIN_VALUE) {
            return new LongConstant(value);
        }
        return NULL;
    }

    @Override
    public long getLong(Record rec) {
        return this.value;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put(this.value).put('L');
    }
}

