/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.str.CharSink;

public class BooleanConstant
extends BooleanFunction
implements ConstantFunction {
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    public static final BooleanConstant FALSE = new BooleanConstant(false);
    private final boolean value;

    private BooleanConstant(boolean value) {
        this.value = value;
    }

    public static BooleanConstant of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public boolean getBool(Record rec) {
        return this.value;
    }

    @Override
    public int getInt(Record rec) {
        return this.value ? 1 : 0;
    }

    @Override
    public float getFloat(Record rec) {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble(Record rec) {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public short getShort(Record rec) {
        return (short)(this.value ? 1 : 0);
    }

    @Override
    public long getLong(Record rec) {
        return this.value ? 1L : 0L;
    }

    @Override
    public char getChar(Record rec) {
        return this.value ? (char)'T' : 'F';
    }

    @Override
    public byte getByte(Record rec) {
        return (byte)(this.value ? 1 : 0);
    }

    @Override
    public long getDate(Record rec) {
        return this.value ? 1L : 0L;
    }

    @Override
    protected String getStr0(Record rec) {
        return this.value ? "true" : "false";
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.value ? 1L : 0L;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put(this.value);
    }
}

