/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc1 = args.getQuick(0);
        Function strFunc2 = args.getQuick(1);
        return new Func(strFunc1, strFunc2);
    }

    private static class Func
    extends StrFunction
    implements BinaryFunction {
        private final Function strFunc1;
        private final Function strFunc2;

        public Func(Function strFunc1, Function strFunc2) {
            this.strFunc1 = strFunc1;
            this.strFunc2 = strFunc2;
        }

        @Override
        public Function getLeft() {
            return this.strFunc1;
        }

        @Override
        public Function getRight() {
            return this.strFunc2;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence cs1 = this.strFunc1.getStr(rec);
            if (cs1 == null) {
                return null;
            }
            CharSequence cs2 = this.strFunc2.getStr(rec);
            if (cs2 == null) {
                return null;
            }
            return Chars.equals(cs1, cs2) ? null : cs1;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence cs1 = this.strFunc1.getStrB(rec);
            if (cs1 == null) {
                return null;
            }
            CharSequence cs2 = this.strFunc2.getStrB(rec);
            if (cs2 == null) {
                return null;
            }
            return Chars.equals(cs1, cs2) ? null : cs1;
        }
    }
}

