/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.CastBooleanToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastByteToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastCharToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDateToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastDoubleToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastFloatToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastIntToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLong256ToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastShortToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToLong256FunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToStrFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastTimestampToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.conditional.BinCaseFunction;
import io.questdb.griffin.engine.functions.conditional.BooleanCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ByteCaseFunction;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionConstructor;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.conditional.CharCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DateCaseFunction;
import io.questdb.griffin.engine.functions.conditional.DoubleCaseFunction;
import io.questdb.griffin.engine.functions.conditional.FloatCaseFunction;
import io.questdb.griffin.engine.functions.conditional.IntCaseFunction;
import io.questdb.griffin.engine.functions.conditional.Long128CaseFunction;
import io.questdb.griffin.engine.functions.conditional.Long256CaseFunction;
import io.questdb.griffin.engine.functions.conditional.LongCaseFunction;
import io.questdb.griffin.engine.functions.conditional.ShortCaseFunction;
import io.questdb.griffin.engine.functions.conditional.StrCaseFunction;
import io.questdb.griffin.engine.functions.conditional.TimestampCaseFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import org.jetbrains.annotations.NotNull;

public class CaseCommon {
    private static final ObjList<CaseFunctionConstructor> constructors = new ObjList();
    private static final LongIntHashMap typeEscalationMap = new LongIntHashMap();
    private static final LongObjHashMap<FunctionFactory> castFactories = new LongObjHashMap();
    private static final ThreadLocal<ObjList<Function>> tlArgs = new ThreadLocal<ObjList>(ObjList::new);
    private static final ThreadLocal<IntList> tlArgPositions = new ThreadLocal<IntList>(IntList::new);

    static int getCommonType(int commonType, int valueType, int valuePos) throws SqlException {
        if (commonType == -1 || ColumnType.isNull(commonType)) {
            return valueType;
        }
        if (ColumnType.isNull(valueType)) {
            return commonType;
        }
        int type = typeEscalationMap.get(Numbers.encodeLowHighInts(commonType, valueType));
        if (type == -1) {
            throw SqlException.$(valuePos, "inconvertible types ").put(ColumnType.nameOf(valueType)).put(" to ").put(ColumnType.nameOf(commonType));
        }
        return type;
    }

    static Function getCastFunction(Function arg, int argPosition, int toType, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (ColumnType.isNull(arg.getType())) {
            return Constants.getNullConstant(toType);
        }
        int keyIndex = castFactories.keyIndex(Numbers.encodeLowHighInts(arg.getType(), toType));
        if (keyIndex < 0) {
            FunctionFactory fact = castFactories.valueAt(keyIndex);
            ObjList<Function> args = tlArgs.get();
            args.clear();
            args.add(arg);
            IntList argPositions = tlArgPositions.get();
            argPositions.clear();
            argPositions.add(argPosition);
            return fact.newInstance(0, args, argPositions, configuration, sqlExecutionContext);
        }
        return arg;
    }

    @NotNull
    private static CaseFunctionConstructor getCaseFunctionConstructor(int position, int returnType) throws SqlException {
        CaseFunctionConstructor constructor = constructors.getQuick(returnType);
        if (constructor == null) {
            throw SqlException.$(position, "not implemented for type '").put(ColumnType.nameOf(returnType)).put('\'');
        }
        return constructor;
    }

    static Function getCaseFunction(int position, int returnType, CaseFunctionPicker picker, ObjList<Function> args) throws SqlException {
        return CaseCommon.getCaseFunctionConstructor(position, returnType).getInstance(position, picker, args);
    }

    static {
        castFactories.put(Numbers.encodeLowHighInts(2, 13), new CastByteToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 11), new CastByteToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(2, 12), new CastByteToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 13), new CastCharToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 11), new CastCharToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(4, 12), new CastCharToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 13), new CastShortToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 11), new CastShortToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(3, 12), new CastShortToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 13), new CastIntToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 11), new CastIntToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(5, 12), new CastIntToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 13), new CastLongToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 11), new CastLongToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(6, 12), new CastLongToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 13), new CastFloatToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 11), new CastFloatToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(9, 12), new CastFloatToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 13), new CastDoubleToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 11), new CastDoubleToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(10, 12), new CastDoubleToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 13), new CastDateToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 11), new CastDateToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(7, 12), new CastDateToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 13), new CastTimestampToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 11), new CastTimestampToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(8, 12), new CastTimestampToSymbolFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(1, 13), new CastBooleanToLong256FunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(13, 11), new CastLong256ToStrFunctionFactory());
        castFactories.put(Numbers.encodeLowHighInts(13, 12), new CastLong256ToSymbolFunctionFactory());
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 1), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(2, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 2), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 1), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(4, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 2), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 1), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 4), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(3, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 2), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 1), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 4), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 3), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(5, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 2), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 1), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 4), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 3), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 5), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(6, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 2), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 1), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 4), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 3), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 5), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 6), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 8), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(9, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 2), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 1), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 4), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 3), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 5), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 6), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 9), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 7), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 8), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(10, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 2), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 1), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 4), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 3), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 5), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 6), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(7, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 2), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 1), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 4), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 3), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 5), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 6), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 7), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(8, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 2), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 1), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 4), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 3), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 5), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 6), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 13), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 9), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 10), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 7), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 8), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(11, 12), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 2), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 1), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 4), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 3), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 5), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 6), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 13), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 9), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 10), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 7), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 8), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(12, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 2), 2);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 1), 1);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 4), 4);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 3), 3);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 5), 5);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 6), 6);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 9), 9);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 10), 10);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 7), 7);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 8), 8);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(1, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 2), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 1), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 4), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 3), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 5), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 6), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 13), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 9), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 10), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 7), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 8), 13);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 11), 11);
        typeEscalationMap.put(Numbers.encodeLowHighInts(13, 12), 12);
        typeEscalationMap.put(Numbers.encodeLowHighInts(18, 18), 18);
        constructors.set(0, 28, null);
        constructors.extendAndSet(11, (position1, picker1, args1) -> new StrCaseFunction(picker1, args1));
        constructors.extendAndSet(5, IntCaseFunction::new);
        constructors.extendAndSet(6, (position2, picker2, args2) -> new LongCaseFunction(picker2, args2));
        constructors.extendAndSet(2, (position2, picker2, args2) -> new ByteCaseFunction(picker2, args2));
        constructors.extendAndSet(1, (position1, picker1, args1) -> new BooleanCaseFunction(picker1, args1));
        constructors.extendAndSet(3, (position3, picker3, args3) -> new ShortCaseFunction(picker3, args3));
        constructors.extendAndSet(4, (position2, picker2, args2) -> new CharCaseFunction(picker2, args2));
        constructors.extendAndSet(9, (position1, picker1, args1) -> new FloatCaseFunction(picker1, args1));
        constructors.extendAndSet(10, (position1, picker1, args1) -> new DoubleCaseFunction(picker1, args1));
        constructors.extendAndSet(13, (position1, picker1, args1) -> new Long256CaseFunction(picker1, args1));
        constructors.extendAndSet(12, (position, picker, args) -> new StrCaseFunction(picker, args));
        constructors.extendAndSet(7, (position, picker, args) -> new DateCaseFunction(picker, args));
        constructors.extendAndSet(8, (position, picker, args) -> new TimestampCaseFunction(picker, args));
        constructors.extendAndSet(18, (position, picker, args) -> new BinCaseFunction(picker, args));
        constructors.extendAndSet(24, (position, picker, args) -> new Long128CaseFunction(picker, args));
    }
}

