/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.std.Long256;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class Long256Column
extends Long256Function
implements ScalarFunction {
    private static final ObjList<Long256Column> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public Long256Column(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static Long256Column newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new Long256Column(columnIndex);
    }

    @Override
    public void getLong256(Record rec, CharSink sink) {
        rec.getLong256(this.columnIndex, sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        return rec.getLong256A(this.columnIndex);
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return rec.getLong256B(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("Long256Column(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new Long256Column(i));
        }
    }
}

