/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class FloatColumn
extends FloatFunction
implements ScalarFunction {
    private static final ObjList<FloatColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public FloatColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static FloatColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new FloatColumn(columnIndex);
    }

    @Override
    public float getFloat(Record rec) {
        return rec.getFloat(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("FloatColumn(").put(this.columnIndex).put(')');
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new FloatColumn(i));
        }
    }
}

