/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.TelemetryJob;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;

public class TableListFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final int idColumn;
    private static final int nameColumn;
    private static final int partitionByColumn;
    private static final int maxUncommittedRowsColumn;
    private static final int commitLagColumn;
    private static final int designatedTimestampColumn;
    private static final Log LOG;
    private static final int writeModeColumn;

    @Override
    public String getSignature() {
        return "tables()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new TableListCursorFactory(configuration.getFilesFacade(), configuration.getRoot(), configuration.getTelemetryConfiguration().hideTables(), configuration.getSystemTableNamePrefix())){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        LOG = LogFactory.getLog(TableListFunctionFactory.class);
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("id", 1L, 5));
        idColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("name", 2L, 11));
        nameColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("designatedTimestamp", 3L, 11));
        designatedTimestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("partitionBy", 4L, 11));
        partitionByColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("maxUncommittedRows", 5L, 5));
        maxUncommittedRowsColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("commitLag", 6L, 6));
        commitLagColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("walEnabled", 7L, 1));
        writeModeColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class TableListCursorFactory
    extends AbstractRecordCursorFactory {
        private final FilesFacade ff;
        private final TableListRecordCursor cursor;
        private final boolean hideTelemetryTables;
        private final CharSequence sysTablePrefix;
        private Path path;
        private TableReaderMetadata metaReader;

        public TableListCursorFactory(FilesFacade ff, CharSequence dbRoot, boolean hideTelemetryTables, CharSequence sysTablePrefix) {
            super(METADATA);
            this.ff = ff;
            this.path = new Path().of(dbRoot).$();
            this.sysTablePrefix = sysTablePrefix;
            this.cursor = new TableListRecordCursor();
            this.hideTelemetryTables = hideTelemetryTables;
            this.metaReader = new TableReaderMetadata(ff);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        protected void _close() {
            this.path = Misc.free(this.path);
            this.metaReader = Misc.free(this.metaReader);
        }

        private class TableListRecordCursor
        implements RecordCursor {
            private final StringSink sink = new StringSink();
            private final TableListRecord record = new TableListRecord();
            private long findPtr = 0L;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                this.findPtr = TableListCursorFactory.this.ff.findClose(this.findPtr);
                TableListCursorFactory.this.metaReader.clear();
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                do {
                    if (this.findPtr == 0L) {
                        this.findPtr = TableListCursorFactory.this.ff.findFirst(TableListCursorFactory.this.path);
                        if (this.findPtr > 0L) continue;
                        return false;
                    }
                    if (TableListCursorFactory.this.ff.findNext(this.findPtr) > 0) continue;
                    return false;
                } while (!Files.isDir(TableListCursorFactory.this.ff.findName(this.findPtr), TableListCursorFactory.this.ff.findType(this.findPtr), this.sink) || !this.record.open(this.sink));
                return true;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void toTop() {
                this.close();
            }

            @Override
            public long size() {
                return -1L;
            }

            public class TableListRecord
            implements Record {
                private int tableId;
                private int maxUncommittedRows;
                private long commitLag;
                private int partitionBy;

                @Override
                public int getInt(int col) {
                    if (col == idColumn) {
                        return this.tableId;
                    }
                    if (col == maxUncommittedRowsColumn) {
                        return this.maxUncommittedRows;
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    if (col == commitLagColumn) {
                        return this.commitLag;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public CharSequence getStr(int col) {
                    if (col == nameColumn) {
                        return TableListRecordCursor.this.sink;
                    }
                    if (col == partitionByColumn) {
                        return PartitionBy.toString(this.partitionBy);
                    }
                    if (col == designatedTimestampColumn && TableListCursorFactory.this.metaReader.getTimestampIndex() > -1) {
                        return TableListCursorFactory.this.metaReader.getColumnName(TableListCursorFactory.this.metaReader.getTimestampIndex());
                    }
                    return null;
                }

                @Override
                public boolean getBool(int col) {
                    if (col == writeModeColumn) {
                        return TableListCursorFactory.this.metaReader.isWalEnabled();
                    }
                    return false;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean open(CharSequence tableName) {
                    if (TableListCursorFactory.this.hideTelemetryTables && (Chars.equals(tableName, TelemetryJob.tableName) || Chars.equals(tableName, TelemetryJob.configTableName) || Chars.startsWith(tableName, TableListCursorFactory.this.sysTablePrefix))) {
                        return false;
                    }
                    int pathLen = TableListCursorFactory.this.path.length();
                    try {
                        TableListCursorFactory.this.path.chop$().concat(tableName).concat("_meta").$();
                        TableListCursorFactory.this.metaReader.deferredInit(TableListCursorFactory.this.path.$(), 426);
                        this.tableId = TableListCursorFactory.this.metaReader.getId();
                        this.maxUncommittedRows = TableListCursorFactory.this.metaReader.getMaxUncommittedRows();
                        this.commitLag = TableListCursorFactory.this.metaReader.getCommitLag();
                        this.partitionBy = TableListCursorFactory.this.metaReader.getPartitionBy();
                    }
                    catch (CairoException e) {
                        LOG.info().$("cannot query table metadata [table=").$(tableName).$(", error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        TableListCursorFactory.this.path.trimTo(pathLen).$();
                    }
                    return true;
                }
            }
        }
    }
}

