/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.IntList;
import io.questdb.std.MemoryTag;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class DumpMemoryUsageFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog("dump-memory-usage");

    @Override
    public String getSignature() {
        return "dump_memory_usage()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new DumpMemoryUsageFunction();
    }

    private static class DumpMemoryUsageFunction
    extends BooleanFunction {
        private DumpMemoryUsageFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            LogRecord record = LOG.advisory();
            record.$("\n\tTOTAL: ").$(Unsafe.getMemUsed());
            record.$("\n\tMALLOC_COUNT: ").$(Unsafe.getMallocCount());
            record.$("\n\tREALLOC_COUNT: ").$(Unsafe.getReallocCount());
            record.$("\n\tFREE_COUNT: ").$(Unsafe.getFreeCount());
            for (int i = 0; i < 42; ++i) {
                record.$('\n').$('\t').$(MemoryTag.nameOf(i)).$(": ").$(Unsafe.getMemUsedByTag(i));
            }
            record.$('\n');
            record.$();
            return true;
        }

        @Override
        public boolean isReadThreadSafe() {
            return true;
        }
    }
}

