/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.DelegatingRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPgClassFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(AbstractPgClassFunctionFactory.class);
    private static final RecordMetadata METADATA;
    private static final String[] relNames;
    private static final int fixedClassLen;
    private static final int INDEX_OID = 0;
    private static final int INDEX_RELNAME = 1;
    private static final int[] staticOid;
    private static final int[] staticRelNamespace;
    private static final int[] staticRelType;
    private static final int[] staticRelOfType;
    private static final int[] staticRelOwner;
    private static final int[] staticRelAm;
    private static final int[] staticRelFileNode;
    private static final int[] staticRelTablespace;
    private static final int[] staticRelAllVisible;
    private static final int[] staticRelToastRelId;
    private static final int[] staticRelRewrite;
    private static final int[][] staticIntColumns;

    @Override
    public boolean isCursor() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new PgClassCursorFactory(configuration, METADATA)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        relNames = new String[]{"pg_class"};
        fixedClassLen = relNames.length;
        staticOid = new int[]{1259};
        staticRelNamespace = new int[]{11};
        staticRelType = new int[]{0};
        staticRelOfType = new int[]{0};
        staticRelOwner = new int[]{0};
        staticRelAm = new int[]{0};
        staticRelFileNode = new int[]{0};
        staticRelTablespace = new int[]{0};
        staticRelAllVisible = new int[]{0};
        staticRelToastRelId = new int[]{0};
        staticRelRewrite = new int[]{0};
        staticIntColumns = new int[][]{staticOid, null, staticRelNamespace, staticRelType, staticRelOfType, staticRelOwner, staticRelAm, staticRelFileNode, staticRelTablespace, null, null, staticRelAllVisible, staticRelToastRelId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, staticRelRewrite};
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 1L, 5));
        metadata.add(new TableColumnMetadata("relname", 2L, 11));
        metadata.add(new TableColumnMetadata("relnamespace", 3L, 5));
        metadata.add(new TableColumnMetadata("reltype", 4L, 5));
        metadata.add(new TableColumnMetadata("reloftype", 5L, 5));
        metadata.add(new TableColumnMetadata("relowner", 6L, 5));
        metadata.add(new TableColumnMetadata("relam", 7L, 5));
        metadata.add(new TableColumnMetadata("relfilenode", 8L, 5));
        metadata.add(new TableColumnMetadata("reltablespace", 9L, 5));
        metadata.add(new TableColumnMetadata("relpages", 10L, 1));
        metadata.add(new TableColumnMetadata("reltuples", 11L, 9));
        metadata.add(new TableColumnMetadata("relallvisible", 12L, 5));
        metadata.add(new TableColumnMetadata("reltoastrelid", 13L, 5));
        metadata.add(new TableColumnMetadata("relhasindex", 14L, 1));
        metadata.add(new TableColumnMetadata("relisshared", 15L, 1));
        metadata.add(new TableColumnMetadata("relpersistence", 16L, 4));
        metadata.add(new TableColumnMetadata("relkind", 17L, 4));
        metadata.add(new TableColumnMetadata("relnatts", 18L, 3));
        metadata.add(new TableColumnMetadata("relchecks", 19L, 3));
        metadata.add(new TableColumnMetadata("relhasrules", 20L, 1));
        metadata.add(new TableColumnMetadata("relhastriggers", 21L, 1));
        metadata.add(new TableColumnMetadata("relhassubclass", 22L, 1));
        metadata.add(new TableColumnMetadata("relrowsecurity", 23L, 1));
        metadata.add(new TableColumnMetadata("relforcerowsecurity", 24L, 1));
        metadata.add(new TableColumnMetadata("relispopulated", 25L, 1));
        metadata.add(new TableColumnMetadata("relreplident", 26L, 4));
        metadata.add(new TableColumnMetadata("relispartition", 27L, 1));
        metadata.add(new TableColumnMetadata("relrewrite", 28L, 5));
        metadata.add(new TableColumnMetadata("relfrozenxid", 29L, 6));
        metadata.add(new TableColumnMetadata("relminmxid", 30L, 6));
        metadata.add(new TableColumnMetadata("relacl", 31L, 11));
        metadata.add(new TableColumnMetadata("reloptions", 32L, 11));
        metadata.add(new TableColumnMetadata("relpartbound", 33L, 11));
        metadata.add(new TableColumnMetadata("relhasoids", 34L, 1));
        metadata.add(new TableColumnMetadata("xmin", 35L, 6));
        METADATA = metadata;
    }

    private static class PgClassRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Path path;
        private final FilesFacade ff;
        private final DelegatingRecord record = new DelegatingRecord();
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final StaticReadingRecord staticReadingRecord = new StaticReadingRecord();
        private final StringSink sink = new StringSink();
        private final int plimit;
        private final int[] intValues = new int[28];
        private final long tempMem;
        private long findFileStruct = 0L;
        private int fixedRelPos = -1;

        public PgClassRecordCursor(CairoConfiguration configuration, Path path, long tempMem) {
            this.ff = configuration.getFilesFacade();
            this.path = path;
            this.path.of(configuration.getRoot()).$();
            this.plimit = this.path.length();
            this.record.of(this.staticReadingRecord);
            this.intValues[0] = 0;
            this.intValues[2] = 2200;
            this.intValues[3] = 0;
            this.intValues[4] = 0;
            this.intValues[5] = 0;
            this.intValues[6] = 0;
            this.intValues[7] = 0;
            this.intValues[8] = 0;
            this.intValues[11] = 0;
            this.intValues[12] = 0;
            this.intValues[27] = 0;
            this.tempMem = tempMem;
        }

        @Override
        public void close() {
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (++this.fixedRelPos < fixedClassLen) {
                return true;
            }
            this.record.of(this.diskReadingRecord);
            if (this.findFileStruct == 0L) {
                this.findFileStruct = this.ff.findFirst(this.path.trimTo(this.plimit).$());
                if (this.findFileStruct > 0L) {
                    return this.next0();
                }
                this.findFileStruct = 0L;
                return false;
            }
            if (this.ff.findNext(this.findFileStruct) > 0) {
                return this.next0();
            }
            return false;
        }

        @Override
        public void toTop() {
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
            this.fixedRelPos = -1;
            this.record.of(this.staticReadingRecord);
        }

        @Override
        public long size() {
            return -1L;
        }

        private boolean next0() {
            do {
                long type;
                long pUtf8NameZ;
                if (!Files.isDir(pUtf8NameZ = this.ff.findName(this.findFileStruct), type = (long)this.ff.findType(this.findFileStruct), this.sink)) continue;
                this.path.trimTo(this.plimit);
                if (!this.ff.exists(this.path.concat(pUtf8NameZ).concat("_meta").$())) continue;
                long fd = this.ff.openRO(this.path);
                if (fd > -1L) {
                    if (this.ff.read(fd, this.tempMem, 4L, 16L) == 4L) {
                        this.intValues[0] = Unsafe.getUnsafe().getInt(this.tempMem);
                        this.ff.close(fd);
                        return true;
                    }
                    LOG.error().$("Could not read table id [fd=").$(fd).$(", errno=").$(this.ff.errno()).$(']').$();
                    this.ff.close(fd);
                } else {
                    LOG.error().$("could not read metadata [file=").$(this.path).$(']').$();
                }
                this.intValues[0] = -1;
                return true;
            } while (this.ff.findNext(this.findFileStruct) > 0);
            this.findFileStruct = this.ff.findClose(this.findFileStruct);
            return false;
        }

        private class DiskReadingRecord
        implements Record {
            private final StringSink utf8SinkB = new StringSink();

            private DiskReadingRecord() {
            }

            @Override
            public boolean getBool(int col) {
                return col == 24;
            }

            @Override
            public char getChar(int col) {
                switch (col) {
                    case 15: {
                        return 'p';
                    }
                    case 16: {
                        return 'r';
                    }
                }
                return 'd';
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public float getFloat(int col) {
                return -1.0f;
            }

            @Override
            public int getInt(int col) {
                return PgClassRecordCursor.this.intValues[col];
            }

            @Override
            public long getLong(int col) {
                return 0L;
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 1) {
                    return PgClassRecordCursor.this.sink;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                if (col == 1) {
                    return this.getName(this.utf8SinkB);
                }
                return null;
            }

            @Override
            public int getStrLen(int col) {
                if (col == 1) {
                    return PgClassRecordCursor.this.sink.length();
                }
                return -1;
            }

            @Nullable
            private CharSequence getName(StringSink sink) {
                sink.clear();
                if (Chars.utf8DecodeZ(PgClassRecordCursor.this.ff.findName(PgClassRecordCursor.this.findFileStruct), sink)) {
                    return sink;
                }
                return null;
            }
        }

        private class StaticReadingRecord
        implements Record {
            private StaticReadingRecord() {
            }

            @Override
            public boolean getBool(int col) {
                return false;
            }

            @Override
            public char getChar(int col) {
                switch (col) {
                    case 15: {
                        return 'u';
                    }
                    case 16: {
                        return 'r';
                    }
                }
                return 'd';
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public float getFloat(int col) {
                return -1.0f;
            }

            @Override
            public int getInt(int col) {
                return staticIntColumns[col][PgClassRecordCursor.this.fixedRelPos];
            }

            @Override
            public long getLong(int col) {
                return 0L;
            }

            @Override
            public CharSequence getStr(int col) {
                if (col == 1) {
                    return relNames[PgClassRecordCursor.this.fixedRelPos];
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                if (col == 1) {
                    return relNames[PgClassRecordCursor.this.fixedRelPos].length();
                }
                return -1;
            }
        }
    }

    private static class PgClassCursorFactory
    extends AbstractRecordCursorFactory {
        private final Path path = new Path();
        private final PgClassRecordCursor cursor;
        private final long tempMem = Unsafe.malloc(4L, 1);

        public PgClassCursorFactory(CairoConfiguration configuration, RecordMetadata metadata) {
            super(metadata);
            this.cursor = new PgClassRecordCursor(configuration, this.path, this.tempMem);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        protected void _close() {
            Misc.free(this.path);
            Unsafe.free(this.tempMem, 4L, 1);
        }
    }
}

