/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public class CastStrToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sk)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            return SymbolConstant.newInstance(arg.getStr(null));
        }
        return new Func(arg);
    }

    private static class Func
    extends SymbolFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceIntHashMap lookupMap = new CharSequenceIntHashMap();
        private final ObjList<CharSequence> symbols = new ObjList();
        private int next = 1;

        public Func(Function arg) {
            this.arg = arg;
            this.symbols.add(null);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            return this.getSymbol(value);
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            CharSequence value = this.arg.getStrB(rec);
            return this.getSymbol(value);
        }

        private CharSequence getSymbol(CharSequence value) {
            int keyIndex;
            if (value != null && (keyIndex = this.lookupMap.keyIndex(value)) > -1) {
                String str = Chars.toString(value);
                this.lookupMap.putAt(keyIndex, str, this.next++);
                this.symbols.add(str);
            }
            return value;
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public int getInt(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return Integer.MIN_VALUE;
            }
            int keyIndex = this.lookupMap.keyIndex(value);
            if (keyIndex > -1) {
                String str = Chars.toString(value);
                this.lookupMap.putAt(keyIndex, str, this.next);
                this.symbols.add(str);
                return this.next++ - 1;
            }
            return this.lookupMap.valueAt(keyIndex) - 1;
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            this.lookupMap.clear();
            this.symbols.clear();
            this.symbols.add(null);
            this.next = 1;
        }

        @Override
        @Nullable
        public SymbolTable newSymbolTable() {
            Func copy = new Func(this.arg);
            copy.lookupMap.putAll(this.lookupMap);
            copy.symbols.clear();
            copy.symbols.addAll(this.symbols);
            copy.next = this.next;
            return copy;
        }
    }
}

